<?php
$tpl_version = "1.3";
if (isset($_GET['ver'])) {
  echo $tpl_version;
  exit;
	// Date: 2014-12-25
}
session_start(); // start PHP session
// Check if a language has been selected
if (isset($_POST['langue'])) {
  $lang = $_POST['langue'];
  $_SESSION['langue'] = $lang; // store session data
}
elseif(isset($_SESSION['langue'])){
  $lang = $_SESSION['langue']; // Default language
}
else {
  $lang = 'en'; // Default language
  $_SESSION['langue'] = $lang;
}

// Include text and data file
require('lang/text_standard_'.$lang.'.php');
include('wt_data_inc.php');

// Include language files available in lang folder
include('include/local_lang.php');
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
	<title><?php echo $location.' - '.$TT_now; ?></title>
	<meta name="keywords" content="Current, actually, last minute" />
	<meta name="description" content="Current weather observations" />
	<link type="text/css" rel="stylesheet" href="style.css" />
	<link type="text/css" rel="stylesheet" href="lib/gallerific/slides.css" />
	<script type="text/javascript" src="lib/jquery-1.4.3.min.js"></script>
	<script type="text/javascript" src="lib/gallerific/jquery.galleriffic.js"></script>
	<script type="text/javascript" src="lib/gallerific/jquery.opacityrollover.js"></script>
	<script type="text/javascript">
		// We only want the thunbnails to display when javascript is disabled
		document.write('<style>.noscript { display: none; }</style>');
		// Day and month names array
		var dayname = new Array ('<?php echo $Tr_sun."','".$Tr_mon."','".$Tr_tue."','".$Tr_wed."','".$Tr_thu."','".$Tr_fri."','".$Tr_sat; ?>');
		var monthname = new Array ('<?php echo $Tr_jan."','".$Tr_feb."','".$Tr_mar."','".$Tr_apr."','".$Tr_may."','".$Tr_jun."','".$Tr_jul."','".$Tr_aug."','".$Tr_sep."','".$Tr_oct."','".$Tr_nov."','".$Tr_dec; ?>');	
	</script>
</head>
<body>
<div id="header">
	<div id="title">
		<h1>Weather Sunset</h1>
		<p><span>by Weather by You!</span></p>
	</div>
	<div id="top_menu">
		<ul>
			<!-- Menu item in inverted order, due to float -->
			<li><a href="system.php">System</a></li>
			<li><a href="infos.php">About</a></li>
			<li><a href="webcam.php">Webcam</a></li>
			<li><a href="ss_gauges.php">Gauges</a></li>
			<li><a href="index.php">Home</a></li>
		</ul>
	</div>
</div>
<div id="base">
  <!-- Right Column -->
	<div id="sidebar">
		<div class="sidebar2">
			<div id="select_lang">
			<?php
				if (isset($nb_langues)) {
			?>
      <form id="lang_sel" method="post" action="<?php echo $_SERVER['PHP_SELF']; ?>">
        <h2 style="padding: 0px">Language:</h2>
        <p><select name="langue" class="styled" title="Select one" onchange="document.forms[0].submit();return false;">
          <?php
            $inc = 0;
            while($inc < $nb_langues) {
              if($languages[$inc][0] == $lang)
                echo '<option value="'.$languages[$inc][0].'" selected="selected">'.$languages[$inc][1].'</option>'."\n";
              else
                echo '<option value="'.$languages[$inc][0].'">'.$languages[$inc][1].'</option>'."\n";
              $inc = $inc + 1;
            }
          ?>
        </select></p>
      </form>  
			<?php
				}
			?>
			</div>
			<div id="calendar">
				<script type="text/javascript">
					var timestamp = new Date();
					var date_yyyy = timestamp.getFullYear();
					var date_mmm = timestamp.getMonth();
					var date_dd = timestamp.getDate();
					var date_day = timestamp.getDay();
				</script>
				<span class="time_month"><script type="text/javascript">document.write(date_yyyy);</script><br />
				<script type="text/javascript">document.write(monthname[date_mmm]);</script></span>
				<h3 style="margin: 15px 0px 8px 0px"><script type="text/javascript">document.write(date_dd);</script></h3>
				<p style="margin: 0px;padding: 0px"><script type="text/javascript">document.write(dayname[date_day]);</script></p>
			</div>
			<div style="height: 600px;">
				<!-- Start Advanced Gallery Html Containers -->				
				<div class="navigation-container">
					<div id="thumbs" class="navigation">
						<a class="pageLink prev" style="visibility: hidden;" href="#" title="Previous Page"></a>
					
						<ul class="thumbs noscript">
							<li>
								<a class="thumb" href="./images/slides/1.jpg" title="Title #1">
									<img src="images/slides/thumbs/t1.jpg" alt="Title #1" />
								</a>
								<div class="caption">
									<div class="image-title">Title #1</div>
									<div class="image-desc">Place for a description</div>
									<div class="download">
										<a href="http://farm4.static.flickr.com/3261/2538183196_8baf9a8015_b.jpg">Could include a link too!</a>
									</div>
								</div>
							</li>
	
							<li>
								<a class="thumb" href="./images/slides/2.jpg" title="Title #2">
									<img src="images/slides/thumbs/t2.jpg" alt="Title #2" />
								</a>
								<div class="caption">
									<p>... or could be real plain without any title or link ...</p>
								</div>
							</li>
	
							<li>
								<a class="thumb" href="./images/slides/3.jpg" title="Title #3">
									<img src="images/slides/thumbs/t3.jpg" alt="Title #3" />
								</a>
								<div class="caption">
									<div class="image-title">Title #3</div>
									<div class="image-desc">Description</div>
								</div>
							</li>
	
							<li>
								<a class="thumb" href="./images/slides/4.jpg" title="Title #4">
									<img src="images/slides/thumbs/t4.jpg" alt="Title #4" />
								</a>
								<div class="caption">
									<div class="image-title">Title #4</div>
									<div class="image-desc">Description</div>
								</div>
							</li>
	
							<li>
								<a class="thumb" href="./images/slides/5.jpg" title="Title #5">
									<img src="images/slides/thumbs/t5.jpg" alt="Title #5" />
								</a>
								<div class="caption">
									<div class="image-title">Title #5</div>
									<div class="image-desc">Description</div>
								</div>
							</li>
	
							<li>
								<a class="thumb" href="./images/slides/6.jpg" title="Title #6">
									<img src="images/slides/thumbs/t6.jpg" alt="Title #6" />
								</a>
								<div class="caption">
									<div class="image-title">Title #6</div>
									<div class="image-desc">Description</div>
								</div>
							</li>
	
							<li>
								<a class="thumb" href="./images/slides/7.jpg" title="Title #7">
									<img src="images/slides/thumbs/t7.jpg" alt="Title #7" />
								</a>
								<div class="caption">
									<div class="image-title">Title #7</div>
									<div class="image-desc">Description</div>
								</div>
							</li>
	
							<li>
								<a class="thumb" href="./images/slides/8.jpg" title="Title #8">
									<img src="images/slides/thumbs/t8.jpg" alt="Title #8" />
								</a>
								<div class="caption">
									<div class="image-title">Title #8</div>
									<div class="image-desc">Description</div>
								</div>
							</li>
	
							<li>
								<a class="thumb" href="./images/slides/9.jpg" title="Title #9">
									<img src="images/slides/thumbs/t9.jpg" alt="Title #9" />
								</a>
								<div class="caption">
									<div class="image-title">Title #9</div>
									<div class="image-desc">Description</div>
								</div>
							</li>
	
							<li>
								<a class="thumb" href="./images/slides/10.jpg" title="Title #10">
									<img src="images/slides/thumbs/t10.jpg" alt="Title #10" />
								</a>
								<div class="caption">
									<div class="image-title">Title #10</div>
									<div class="image-desc">Description</div>
								</div>
							</li>
	
							<li>
								<a class="thumb" href="./images/slides/11.jpg" title="Title #11">
									<img src="images/slides/thumbs/t11.jpg" alt="Title #11" />
								</a>
								<div class="caption">
									<div class="image-title">Title #11</div>
									<div class="image-desc">Description</div>
								</div>
							</li>
	
							<li>
								<a class="thumb" href="./images/slides/12.jpg" title="Title #12">
									<img src="images/slides/thumbs/t12.jpg" alt="Title #12" />
								</a>
								<div class="caption">
									<div class="image-title">Title #12</div>
									<div class="image-desc">Description</div>
								</div>
							</li>
						</ul>
						<a class="pageLink next" style="visibility: hidden;" href="#" title="Next Page"></a>
					</div>
				</div>
				</div>
				<!-- End Gallery Html Containers -->
				<div style="clear: both;"></div>

		</div>
    <div id="sidebar-credit">
			Design <a href="http://wptemplates.org/" title="Wordpress Themes">Wp Templates</a><p> and <a href="http://www.thoughtmechanics.com/chicago-web-design-company/" title="Designed By TM">Designed By TM</a>.</p>
		</div>
	</div>
  <!-- Center  -->
	<div id="base_header" style="height: 75px">
		<h1 style="text-align:center">Our most beautiful photos</h1>
		<h2 style="text-align:center"><small>Around area</small></h2>
	</div>
	<div id="wrap">
		<div id="content_top"></div>
		<div id="content">

				<div class="slides_content">
					<div class="slideshow-container">
						<div id="controls" class="controls"></div>
						<div id="loading" class="loader"></div>
						<div id="slideshow" class="slideshow"></div>
					</div>
					<div id="caption" class="caption-container">
						<div class="photo-index"></div>
					</div>
				</div>

    </div>
		<div class="clear"></div>
	</div>
</div>
<div id="bg_btm">
	<div id="footer">
		<p id="footer_notes">Copyright (c) 2014 <a href="http://weatherbyyou.com">Weather by You!</a></p>
	</div>
</div>
<script type="text/javascript">
	jQuery(document).ready(function($) {
		// We only want these styles applied when javascript is enabled
		$('div.slides_content').css('display', 'block');

		// Initially set opacity on thumbs and add
		// additional styling for hover effect on thumbs
		var onMouseOutOpacity = 0.50;
		$('#thumbs ul.thumbs li, div.navigation a.pageLink').opacityrollover({
			mouseOutOpacity:   onMouseOutOpacity,
			mouseOverOpacity:  1.0,
			fadeSpeed:         'fast',
			exemptionSelector: '.selected'
		});
		
		// Initialize Advanced Galleriffic Gallery
		var gallery = $('#thumbs').galleriffic({
			delay:                     2500,
			numThumbs:                 6,
			preloadAhead:              6,
			enableTopPager:            false,
			enableBottomPager:         false,
			imageContainerSel:         '#slideshow',
			controlsContainerSel:      '#controls',
			captionContainerSel:       '#caption',
			loadingContainerSel:       '#loading',
			renderSSControls:          true,
			renderNavControls:         true,
			playLinkText:              'Play Slideshow',
			pauseLinkText:             'Pause Slideshow',
			prevLinkText:              '&lsaquo; Prev ',
			nextLinkText:              'Next &rsaquo;',
			nextPageLinkText:          'Next &rsaquo;',
			prevPageLinkText:          '&lsaquo; Prev',
			enableHistory:             false,
			autoStart:                 false,
			syncTransitions:           false,
			defaultTransitionDuration: 900,
			onSlideChange:             function(prevIndex, nextIndex) {
				// 'this' refers to the gallery, which is an extension of $('#thumbs')
				this.find('ul.thumbs').children()
					.eq(prevIndex).fadeTo('fast', onMouseOutOpacity).end()
					.eq(nextIndex).fadeTo('fast', 1.0);

				// Update the photo index display
				this.$captionContainer.find('div.photo-index')
					.html('Photo '+ (nextIndex+1) +' of '+ this.data.length);
			},
			onPageTransitionOut:       function(callback) {
				this.fadeTo('fast', 0.0, callback);
			},
			onPageTransitionIn:        function() {
				var prevPageLink = this.find('a.prev').css('visibility', 'hidden');
				var nextPageLink = this.find('a.next').css('visibility', 'hidden');
				
				// Show appropriate next / prev page links
				if (this.displayedPage > 0)
					prevPageLink.css('visibility', 'visible');
				var lastPage = this.getNumPages() - 1;
				if (this.displayedPage < lastPage)
					nextPageLink.css('visibility', 'visible');

				this.fadeTo('fast', 1.0);
			}
		});

		/**** Event handlers for custom next / prev page links ****/
		gallery.find('a.prev').click(function(e) {
			gallery.previousPage();
			e.preventDefault();
		});
		gallery.find('a.next').click(function(e) {
			gallery.nextPage();
			e.preventDefault();
		});
	});
</script>
</body>
</html>