<?php
// put your own password below to replace 'adminpass'
$LOGIN_INFORMATION = array(
  'adminpass'
);

// request login? true - show login and password boxes, false - password box only
define('USE_USERNAME', false);

// User will be redirected to this page after logout
define('LOGOUT_URL', 'http://www.example.com/');

// time out after NN minutes of inactivity. Set to 0 to not timeout
define('TIMEOUT_MINUTES', 0);

// This parameter is only useful when TIMEOUT_MINUTES is not zero
// true - timeout time from last activity, false - timeout time from login
define('TIMEOUT_CHECK_ACTIVITY', true);


///////////////////////////////////////////////////////
// do not change code below
///////////////////////////////////////////////////////

// show usage example
if(isset($_GET['help'])) {
  die('Include following code into every page you would like to protect, at the very beginning (first line):<br>&lt;?php include("' . str_replace('\\','\\\\',__FILE__) . '"); ?&gt;');
}

// timeout in seconds
$timeout = (TIMEOUT_MINUTES == 0 ? 0 : time() + TIMEOUT_MINUTES * 60);

// logout?
if(isset($_GET['logout'])) {
  setcookie("verify", '', $timeout, '/'); // clear password;
  header('Location: ' . LOGOUT_URL);
  exit();
}

if(!function_exists('showLoginPasswordProtect')) {

// show login form
function showLoginPasswordProtect($error_msg) {
require('lang/text_standard_en.php');
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
	<title>Weather Sunset template Supervisor screen</title>
	<meta name="keywords" content="Current, actually, last minute" />
	<meta name="description" content="Current weather observations" />
	<link type="text/css" rel="stylesheet" href="style.css" />
  <link rel="stylesheet" type="text/css" href="ajaxtabs/ajaxtabs.css" />
  <script type="text/javascript" src="ajaxtabs/ajaxtabs.js"></script>
	<script type="text/javascript">
		var dayname = new Array ('<?php echo $Tr_sun."','".$Tr_mon."','".$Tr_tue."','".$Tr_wed."','".$Tr_thu."','".$Tr_fri."','".$Tr_sat; ?>');
		var monthname = new Array ('<?php echo $Tr_jan."','".$Tr_feb."','".$Tr_mar."','".$Tr_apr."','".$Tr_may."','".$Tr_jun."','".$Tr_jul."','".$Tr_aug."','".$Tr_sep."','".$Tr_oct."','".$Tr_nov."','".$Tr_dec; ?>');	
	</script>
</head>
<body>
<div id="header">
	<div id="title">
		<h1>Weather Sunset</h1>
		<p><span>by Weather by You!</span></p>
	</div>
	<div id="top_menu" style="margin-top: 35px;">
		<ul>
			<!-- Menu item in inverted order, due to float -->
			<li><a href="infos.php">Infos</a></li>
			<li><a href="images.php">Images</a></li>
			<li><a href="ss_gauges.php">Gauges</a></li>
			<li><a href="index.php">Home</a></li>
		</ul>
	</div>
</div>
<div id="base">
  <!-- Right Column -->
	<div id="sidebar">
		<div class="sidebar2">
			<div id="select_lang">
			<?php
				if (isset($nb_langues)) {
			?>
      <form id="lang_sel" method="post" action="<?php echo $_SERVER['PHP_SELF']; ?>">
        <h2 style="padding: 0px">Language:</h2>
        <p><select name="langue" class="styled" title="Select one" onchange="document.forms[0].submit();return false;">
          <?php
            $inc = 0;
            while($inc < $nb_langues) {
              if($languages[$inc][0] == $lang)
                echo '<option value="'.$languages[$inc][0].'" selected="selected">'.$languages[$inc][1].'</option>'."\n";
              else
                echo '<option value="'.$languages[$inc][0].'">'.$languages[$inc][1].'</option>'."\n";
              $inc = $inc + 1;
            }
          ?>
        </select></p>
      </form>  
			<?php
				}
			?>
			</div>
			<div id="calendar">
				<script type="text/javascript">
					var timestamp = new Date();
					var date_yyyy = timestamp.getFullYear();
					var date_mmm = timestamp.getMonth();
					var date_dd = timestamp.getDate();
					var date_day = timestamp.getDay();
				</script>
				<span class="time_month"><script type="text/javascript">document.write(date_yyyy);</script><br />
				<script type="text/javascript">document.write(monthname[date_mmm]);</script></span>
				<h3 style="margin: 15px 0px 8px 0px"><script type="text/javascript">document.write(date_dd);</script></h3>
				<p style="margin: 0px;padding: 0px"><script type="text/javascript">document.write(dayname[date_day]);</script></p>
				<div class="clear"></div>
			</div>
			<br />
		</div>
    <div id="sidebar-credit">
			Design <a href="http://wptemplates.org/" title="Wordpress Themes">Wp Templates</a><p> and <a href="http://www.thoughtmechanics.com/chicago-web-design-company/" title="Designed By TM">Designed By TM</a>.</p>
		</div>
	</div>
  <!-- Centre  -->
	<div id="base_header">
		<h1 style="text-align: center">Supervisor login page</h1>
	</div>
	<div id="wrap">
		<div id="content_top" style="margin-top: 0px"></div>
		<div id="content">
			<!-- Dbut entete du centre de page  -->
			<div style="width:500px; margin:0 auto; padding: 150px 0px; text-align:center;">
				<form method="post">
					<h3>Please enter password to access this page</h3>
					<font color="red"><?php echo $error_msg; ?></font><br />
					<?php if (USE_USERNAME) echo 'Login:<br /><input type="input" name="access_login" /><br />Password:<br />'; ?>
					<input type="password" name="access_password" /><p></p><input type="submit" name="Submit" value="Submit" />
				</form>
				<br />
				<a style="font-size:9px; font-family: Verdana, Arial;" href="http://www.zubrag.com/scripts/password-protect.php" title="Download Password Protector">Powered by Password Protect</a>
			</div>
		</div><!--//body-->
		<div class="clear"></div>
	</div>
</div>
<div id="bg_btm">
	<div id="footer">
		<p id="footer_notes">Copyright (c) 2012 <a href="http://weatherbyyou.com">Weather by You!</a></p>
	</div>
</div>
</body>
</html>
<?php 
  // stop at this point
  die();
}
}

// user provided password
if (isset($_POST['access_password'])) {
  $login = isset($_POST['access_login']) ? $_POST['access_login'] : '';
  $pass = $_POST['access_password'];
  if (!USE_USERNAME && !in_array($pass, $LOGIN_INFORMATION)
  || (USE_USERNAME && ( !array_key_exists($login, $LOGIN_INFORMATION) || $LOGIN_INFORMATION[$login] != $pass ) ) 
  ) {
    showLoginPasswordProtect("Incorrect password.");
  }
  else {
    // set cookie if password was validated
    setcookie("verify", md5($login.'%'.$pass), $timeout, '/');
    
    // Some programs (like Form1 Bilder) check $_POST array to see if parameters passed
    // So need to clear password protector variables
    unset($_POST['access_login']);
    unset($_POST['access_password']);
    unset($_POST['Submit']);
  }
}
else {
  // check if password cookie is set
  if (!isset($_COOKIE['verify'])) {
    showLoginPasswordProtect("");
  }
  // check if cookie is good
  $found = false;
  foreach($LOGIN_INFORMATION as $key=>$val) {
    $lp = (USE_USERNAME ? $key : '') .'%'.$val;
    if ($_COOKIE['verify'] == md5($lp)) {
      $found = true;
      // prolong timeout
      if (TIMEOUT_CHECK_ACTIVITY) {
        setcookie("verify", md5($lp), $timeout, '/');
      }
      break;
    }
  }
  if (!$found) {
    showLoginPasswordProtect("");
  }
}
?>