<?php
function fetchURL($url) {
	$url_parsed = parse_url($url);
	$host = $url_parsed["host"];
	if (isset($url_parsed["port"]))
		$port = $url_parsed["port"];
	else
		$port = 80;
	$path = $url_parsed["path"];
	if (isset($url_parsed["query"]) && ($url_parsed["query"] != ""))
		$path .= "?".$url_parsed["query"];
	$out = "GET $path HTTP/1.0\r\nHost: $host\r\n\r\n";
	$fp = fsockopen($host, $port, $errno, $errstr, 30);
	fwrite($fp, $out);
	$body = false;
	$in = '';
	while (!feof($fp)) {
		$s = fgets($fp, 1024);
		if ($body)
			$in .= $s;
		if ($s == "\r\n")
			$body = true;
	}
	fclose($fp);
	return $in;
}

function save_local($in, $file) {
  $fp = fopen($file, "w");
  if ($fp) {
    $write = fputs($fp, $in);
    fclose($fp);
  }
  else {
    echo "Unable to write update file $file\n";
		return FALSE;
	}
	return TRUE;
}

function save_lang($lang, $file) {
  $fp = fopen($file, "w");
  if ($fp) {
		$write = fputs($fp, '<'.'?php'."\n");
		$write = fputs($fp, '$languages = array(array(\''.$lang['abv'][0].'\', \''.$lang['name'][0].'\')');	
		for($inc=1; $inc < count($lang['name']); $inc++) {
			//$write = fputs($fp, $in);
			$write = fputs($fp, ', array(\''.$lang['abv'][$inc].'\', \''.$lang['name'][$inc].'\')');	
		}
		$write = fputs($fp, ");\n");
		$write = fputs($fp, '$nb_langues = '.$inc.";\n".'?'.'>');
    fclose($fp);
  }
  else {
    echo "Unable to write update file $file\n";
		return FALSE;
	}
	return TRUE;
}
?>