<?php 
$tpl_version = "1.4";
if (isset($_GET['ver'])) {
  echo $tpl_version;
  exit;
	// Date: 2014-12-25
}

//  -- Configuration section --
// If you have a Fine Offset Model 3080
$FO_3080 = FALSE;
// If you have a Hydreon RG-11
$sensor_rg = TRUE;

session_start(); // start PHP session
// Check if a language has been selected
if (isset($_POST['langue'])) {
  $lang = $_POST['langue'];
  $_SESSION['langue'] = $lang; // store session data
}
elseif(isset($_SESSION['langue'])){
  $lang = $_SESSION['langue']; // Default language
}
else {
  $lang = 'en'; // Default language
  $_SESSION['langue'] = $lang;
}

// Include text and data file
require('lang/text_standard_en.php');  // Fall-back language: English
require('lang/text_standard_'.$lang.'.php');
include('wt_data_inc.php');

// Check if you have a Davis station
if ($DavisTotalPacketsReceived == "0")
	$davis = FALSE;
else
	$davis = TRUE;
// Check if you have a UV Sensor
if (($UV == "0") AND ($UVTH == "0") AND ($UVYH == "0") AND ($RecentUV == "0"))
	$sensor_uv = FALSE;
else
	$sensor_uv = TRUE;
// Check if you have a Solar Sensor
if ((intval($ET) == 0) AND ($SolarRad=="0") AND ($solarTH=="0") AND ($solarYH=="0") AND ($RecentSolarRad=="0"))
	$sensor_solar = FALSE;
else
	$sensor_solar = TRUE;
// Minutes from last rain tip, converted to Day/Hour/Min/
//H = 60, Day = 1440, Month = 43200
$MSLRT = $MinutesSinceLastRainTip;
$MSLRT_str = "";
if(($MinutesSinceLastRainTip / 43200) > 1) {
	$MSLRT_str = $MSLRT_str .(int)($MinutesSinceLastRainTip / 43200)." Month, ";
	$MSLRT = $MSLRT - (int)($MinutesSinceLastRainTip / 43200) * 43200;
}
if(($MSLRT / 1440) > 1) {
	$MSLRT_str = $MSLRT_str.(int)($MSLRT / 1440)." Day, ";
	$MSLRT = $MSLRT - (int)($MSLRT / 1440) * 1440;
}
if(($MSLRT / 60) > 1) {
	$MSLRT_str = $MSLRT_str.(int)($MSLRT / 60)." Hour, ";
	$MSLRT = $MSLRT - (int)($MSLRT / 60) * 60;
}
$MSLRT_str = $MSLRT_str.(int)$MSLRT." Min";

?>
<!-- WEATHER DATA BEGIN -->
<h1><?php echo $TT_now; ?></h1>
<table id="tbl_4cols" border="0" cellpadding="0" cellspacing="0" summary="Observations actuelles">
<caption style="text-align: left;"><strong>
	<?php 
		echo $Tr_CondAt.' '.$time; 
		if ($currcondenc != "") {	echo '. '.$Tr_currcond.': '.$currcondenc; }
	?>
	</strong></caption>
<col width="200" />
<col width="160" />
<col width="200" />
<tr>
	<td colspan="4" class="tableseparator"><?php echo $TT_TempAndHum; ?></td>
</tr><tr class="td_data">
	<?php
		if ($davis) {
			echo '<td>'.$Tr_THWindex.'</td><td>'.$THWindex.'</td>';
			if (intval($THSWindex) == "0")
				echo '<td>&nbsp;</td><td>&nbsp;</td></tr><tr class="td_data">';
			else
				echo '<td>'.$Tr_THSWindex.'</td><td>'.$THSWindex.'</td></tr><tr class="td_data">';
		}
		echo '<td>'.$now_temp.'</td><td>'.$temp.$tempunit.'</td><td style="width: 200px;">'.$now_hum.'</td><td>'.$hum.'%</td>';
	?>
</tr><tr class="td_data">
	<?php echo '<td>'.$Tr_apptemp.'</td><td>'.$apptemp.$tempunit.'</td><td>'.$Tr_temptrend.'  (3hrs)</td><td>'.$temptrend.$tempunit.'</td>'; ?>
</tr>
 <tr class="td_data">
	<?php echo '<td>'.$Tr_wetbulb.'</td><td>'.$wetbulb.$tempunit.'</td><td>'.$Tr_temptrend.' <small>('.$temptrendtext.')</small></td><td>'.$TempChangeLastHour.$tempunit.'</td>'; ?>
</tr><tr class="td_data">
	<?php
		echo '<td>'.$Tr_avgtemp.'</td><td>'.$avgtemp.$tempunit.'</td><td>'.$Tr_dew.'</td><td>'.$dew.$tempunit.'</td></tr><tr class="td_data">';
		// If no Windchill
		if ($wchill == $temp)
			echo '<td>'.$Tr_wchill.'</td><td>no</td>';
		else
			echo '<td>'.$Tr_wchill.'</td><td>'.$wchill.$tempunit.'</td>';
		echo '<td>'.$Tr_chillhours.'</td><td>'.$chillhours.' </td>'; ?> 
</tr><tr class="td_data">
	<?php
		// If no Humidex
		if ($humidex == $temp)
			echo '<td>'.$Tr_humidex.'</td><td>no</td>';
		else
			echo '<td>'.$Tr_humidex.'</td><td>'.$humidex.$tempunit.'</td>';
		// If no heatindex
		if ($heatindex == $temp)
			echo '<td>'.$Tr_heatindex.'</td><td>no</td>';
		else
			echo '<td>'.$Tr_heatindex.'</td><td>'.$heatindex.$tempunit.'</td>';
	?>
</tr>	
<tr class="td_data">
	<?php 
		// If equipped with UV sensor
		if ($sensor_uv == TRUE) {
			echo '<td>'.$Tr_IsSunny.'</td><td>';
			if ($IsSunny == 0)
				echo "<td>No</td>\n";
			else
				echo "<td>Yes</td>\n";
			echo '<td>'.$Tr_UV.'</td><td>'.$UV."</td></tr>\n".'<tr class="td_data">';
		}
		// For station with Solar sensor
		if ($sensor_solar == TRUE) {
			echo '<td>'.$Tr_CurrentSolarMax.'</td><td>'.$CurrentSolarMax.'  W/m<sup>2</sup></td>';
			echo '<td>'.$Tr_SolarRad.'</td><td>'.$SolarRad." W/m<sup>2</sup></td></tr>\n".'<tr class="td_data">';
			if ($davis == TRUE)
				echo '<td>'.$Tr_ET.'</td><td>'.$ET."</td><td></td><td></td></tr>\n".'<tr class="td_data">';
		}
		echo '<td>'.$Tr_cloudbase.'</td><td>'.$cloudbasevalue.' '.$cloudbaseunit.'</td>';
		echo '<td>'.$Tr_IsSunUp.'</td><td>';
		if ($IsSunUp == "0") 
       echo 'No';
     else
       echo 'Yes';
		if ($FO_3080 == TRUE)
			echo '<td>Lux</td><td>'.$Light.'</td><td>&nbsp;</td><td>&nbsp;</td>';
	?>
</tr><tr>
	<td colspan="4" class="tableseparator"><?php echo $TT_Rainfall; ?></td>
</tr><tr class="td_data">
	<?php echo '<td>'.$Tr_rrate.'</td><td>'.$rrate.' '.$rainunit.'/hr</td><td>'.$Tr_rfall.'</td><td>'.$rfall.' '.$rainunit.'</td>'; ?>
</tr><tr class="td_data">
	<?php echo '<td>'.$Tr_rhour.'</td><td>'.$rhour.' '.$rainunit.'</td><td>'.$month_rain_so_far.'</td><td>'.$rmonth.' '.$rainunit.'</td>'; ?>
</tr><tr class="td_data">
	<?php echo '<td>'.$Tr_rmidnight.'</td><td>'.$rmidnight.' '.$rainunit.'</td><td>'.$year_rain_so_far.'</td><td>'.$ryear.' '.$rainunit.'</td>'; ?>
</tr><tr class="td_data">
	<?php echo '<td>'.$Tr_r24hour.'</td><td>'.$r24hour.' '.$rainunit.'</td><td>'.$Tr_LastRainTipISO.'<small> ('.$MSLRT_str.'</small>)</td><td>'.$LastRainTipISO.'</td>'; 
		// If a RG-11 rain sensor is available
		if ($sensor_rg == TRUE) {
			echo "</tr>\n".'<tr class="td_data"><td>RG-11 '.$Tr_rmonth.'</td><td>'.$RG11RainToday.$rainunit.'</td>';
		}
		if ($snowdepth == "0")
			echo '<td>&nbsp;</td><td>&nbsp;</td>';
		else
			echo '<td>Snow depth</td><td>'.$snowdepth.'</td>';
	?>
</tr><tr>
	<td colspan="4" class="tableseparator"><?php echo $TT_Wind; ?></td>
</tr><tr class="td_data">
	<?php echo '<td>'.$Tr_wlatest.'</td><td>'.$wlatest.' '.$windunit.'</td><td>'.$Tr_currentwdir.'</td><td>'.$currentwdir.'</td>'; ?>
</tr><tr class="td_data">
	<?php echo '<td>'.$Tr_wgust.'</td><td>'.$wgust.' '.$windunit.'</td><td>'.$Tr_bearing.'</td><td>'.$bearing.'&deg;</td>'; ?>
</tr><tr class="td_data">
	<?php echo '<td>'.$Tr_wspeed.'</td><td>'.$wspeed.'&deg; </td><td>'.$Tr_avgbearing.'</td><td>'.$avgbearing.'&deg;</td>'; ?>
</tr><tr class="td_data">
	<?php echo '<td>'.$Tr_BearingRangeFrom.'</td><td>'.$BearingRangeFrom10.'&deg; ('.$BearingRangeFrom.'&deg;)</td><td>'.$Tr_BearingRangeTo.'</td><td>'.$BearingRangeTo10.'&deg; ('.$BearingRangeTo.'&deg;)</td>'; ?>
</tr><tr class="td_data">
	<?php echo '<td>'.$Tr_beaufort.'</td><td>'.$beaufort.'</td><td>'.$beaudesc.'</td><td>'.$wdir.'</td>'; ?>
</tr><tr>
	<td colspan="4" class="tableseparator"><?php echo $TT_Press; ?></td>
</tr><tr class="td_data">
	<?php echo '<td>'.$Tr_press.'</td><td>'.$press.' '.$pressunit.'</td><td>'.$Tr_altimeterpressure.'</td><td>'.$altimeterpressure.' '.$pressunit.'</td>'; ?>
</tr><tr class="td_data">
	<?php echo '<td>'.$Tr_presstrend.'</td><td>'.$presstrendval.' '.$pressunit.'</td><td>'.$presstrend.'</td>'; ?>
</tr><tr>
	<td colspan="4" class="tableseparator"><?php echo $TT_SunAndMoon; ?></td>
</tr><tr class="td_data">
	<?php echo '<td>'.$Tr_sunrise.'</td><td>'.$sunrise.'</td><td>'.$Tr_sunset.'</td><td>'.$sunset.'</td>'; ?>
</tr><tr class="td_data">
	<?php echo '<td>'.$Tr_dawn.'</td><td>'.$dawn.'</td><td>'.$Tr_dusk.'</td><td>'.$dusk.'</td>'; ?>
</tr><tr class="td_data">
	<?php echo '<td>'.$Tr_moonrise.'</td><td>'.$moonrise.'</td><td>'.$Tr_moonset.'</td><td>'.$moonset.'</td>'; ?>
</tr><tr class="td_data">
	<?php echo '<td>'.$Tr_daylength.'</td><td>'.$daylength.'</td><td>'.$Tr_daylightlength.'</td><td>'.$daylightlength.'</td>'; ?>
</tr><tr class="td_data">
	<?php echo '<td>'.$Tr_MoonAge.'</td><td>'.$MoonAge.' '.$TT_day.'</td><td>&nbsp;</td><td>&nbsp;</td>'; ?>
</tr><tr>
	<td colspan="4" class="tableseparator"><?php echo $TT_OurLoc; ?></td>
</tr><tr class="td_data">
	<?php echo '<td>'.$Tr_latitude.'</td><td>'.$latitude.'</td><td>'.$Tr_longitude.'</td><td>'.$longitude.'</td>'; ?>
</tr><tr class="td_data">
	<?php echo '<td>'.$Tr_altitude.'</td><td>'.$altitude.'</td><td>&nbsp;</td><td>&nbsp;</td>'; ?>
</tr>
</table>