<?php
$tpl_version = "1.2";
if (isset($_GET['ver'])) {
  echo $tpl_version;
  exit;
	// Date: 2014-12-25
}

session_start(); // start PHP session
// Check if a language has been selected
if (isset($_POST['langue'])) {
  $lang = $_POST['langue'];
  $_SESSION['langue'] = $lang; // store session data
}
elseif(isset($_SESSION['langue'])){
  $lang = $_SESSION['langue']; // Default language
}
else {
  $lang = 'en'; // Default language
  $_SESSION['langue'] = $lang;
}

// Include text and data file
require('lang/text_standard_en.php');  // Fall-back language: English
require('lang/text_standard_'.$lang.'.php');
include('wt_data_inc.php');

// Include language files available in lang folder
include('include/local_lang.php');
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
  <title><?php echo $location.' - '.$TT_about; ?></title>
	<meta name="keywords" content="Current, actually, last minute" />
	<meta name="description" content="Current weather observations" />
	<link type="text/css" rel="stylesheet" href="style.css" />
	<script type="text/javascript">
		var dayname = new Array ('<?php echo $Tr_sun."','".$Tr_mon."','".$Tr_tue."','".$Tr_wed."','".$Tr_thu."','".$Tr_fri."','".$Tr_sat; ?>');
		var monthname = new Array ('<?php echo $Tr_jan."','".$Tr_feb."','".$Tr_mar."','".$Tr_apr."','".$Tr_may."','".$Tr_jun."','".$Tr_jul."','".$Tr_aug."','".$Tr_sep."','".$Tr_oct."','".$Tr_nov."','".$Tr_dec; ?>');	
	</script>
</head>
<body>
<div id="header">
	<div id="title">
		<h1>Weather Sunset</h1>
		<p><span>by Weather by You!</span></p>
	</div>
	<div id="top_menu" style="margin-top: 35px;">
		<ul>
			<!-- Menu item in inverted order, due to float -->
			<li><a href="system.php">System</a></li>
			<li><a href="infos.php">About</a></li>
			<li><a href="images.php">Images</a></li>
			<li><a href="ss_gauges.php">Gauges</a></li>
			<li><a href="index.php">Home</a></li>
		</ul>
	</div>
</div>
<div id="base">
  <!-- Right Column -->
	<div id="sidebar">
		<div class="sidebar2">
			<div id="select_lang">
			<?php
				if (isset($nb_langues)) {
			?>
      <form id="lang_sel" method="post" action="<?php echo $_SERVER['PHP_SELF']; ?>">
        <h2 style="padding: 0px">Language:</h2>
        <p><select name="langue" class="styled" title="Select one" onchange="document.forms[0].submit();return false;">
          <?php
            $inc = 0;
            while($inc < $nb_langues) {
              if($languages[$inc][0] == $lang)
                echo '<option value="'.$languages[$inc][0].'" selected="selected">'.$languages[$inc][1].'</option>'."\n";
              else
                echo '<option value="'.$languages[$inc][0].'">'.$languages[$inc][1].'</option>'."\n";
              $inc = $inc + 1;
            }
          ?>
        </select></p>
      </form>  
			<?php
				}
			?>
			</div>
			<div id="calendar">
				<script type="text/javascript">
					var timestamp = new Date();
					var date_yyyy = timestamp.getFullYear();
					var date_mmm = timestamp.getMonth();
					var date_dd = timestamp.getDate();
					var date_day = timestamp.getDay();
				</script>
				<span class="time_month"><script type="text/javascript">document.write(date_yyyy);</script><br />
				<script type="text/javascript">document.write(monthname[date_mmm]);</script></span>
				<h3 style="margin: 15px 0px 8px 0px"><script type="text/javascript">document.write(date_dd);</script></h3>
				<p style="margin: 0px;padding: 0px"><script type="text/javascript">document.write(dayname[date_day]);</script></p>
				<div class="clear"></div>
			</div>
			<div style="margin: 20px 10px 70px 10px">
				<h2 class="title" style="text-align: center"><?php echo $TT_networks; ?></h2>
				<p><?php echo $Tr_netw_desc; ?></p>
				<div style="margin: 0px 15px; border: 1px solid #A58D65">
					<p><a href="http://www.pwsweather.com/"><img src="images/logo_pws.jpg" alt="Personnal Weather Stations" title="Personnal Weather Stations" /></a></p>
					<p><a href="http://www.wunderground.com/"><img src="images/wuLogo.jpg" alt="Weather Underground" title="Weather Underground" /></a></p>
					<p><a href="http://wow.metoffice.gov.uk/home"><img src="images/WOW.jpg" alt="Weather Observations Website" title="Weather Observations Website" /></a></p>
					<p><a href="http://wxqa.com/"><img src="images/logo_cwop.jpg" alt="Citizen Weather Observer Program" title="Citizen Weather Observer Program" /></a></p>
					<p><a href="http://www.aprs.org/"><img src="images/logo_aprs.jpg" alt="Automatic Packet Reporting System " title="Automatic Packet Reporting System " /></a></p>
					<p><a href="http://weather.weatherbug.com/"><img src="images/logo_weatherbug.jpg" alt="WeatherBug" title="WeatherBug" /></a></p>
				</div>
			</div>
		</div>
    <div id="sidebar-credit">
			Design <a href="http://wptemplates.org/" title="Wordpress Themes">Wp Templates</a><p> and <a href="http://www.thoughtmechanics.com/chicago-web-design-company/" title="Designed By TM">Designed By TM</a>.</p>
		</div>
	</div>
  <!-- Centre  -->
	<div id="base_header">
		<h1 style="text-align: center"><?php echo $TT_about; ?></h1>
	</div>
	<div id="wrap">
		<div id="content_top" style="margin-top: 0px;"></div>
		<div id="content">
			<div class="boxes" style="padding: 12px 40px">
				<p><?php echo $Tr_intro1.' : (YOUR CITY) '.$Tr_intro2.' '.$recordsbegandate; ?></p>
				<p><?php echo $Tr_intro3.' '.$Tr_intro4.' '.$interval. ' '.$Tr_minutes.', '.$Tr_intro5.' 24/7'; ?></p>
				<p><?php echo $Tr_intro6.'.'; ?></p>
			</div>
			<div class="boxes">
				<img style="float: left; padding: 30px 30px 20px 10px;" src="style/MyCity.jpg" alt="" title=""  />
				<h2><?php echo $TT_OurLoc; ?></h2>
				<h3><?php echo $Tr_desc; ?></h3>
				<p><strong><?php echo $Tr_country; ?> :</strong> St-Ours-sur-Richelieu, Québec, Canada</p>
				<p>Our installations are located in St-Ours, Quebec a little town of 1609 poeples at 80km east from Montréal. Until 1992 our town was THE smallest town in Canada. We see at left an aerian view of our town.</p>
			</div>
			<div class="boxes">
				<div style="float: left;padding: 30px 60px 0px 10px;">
					<iframe width="250" height="200" scrolling="no" marginheight="0" marginwidth="0" src="http://maps.google.com/maps?q=Saint-Ours,+QC+J0G+1P0,+Canada&amp;hl=fr&amp;ie=UTF8&amp;sll=46.1532,-72.69104&amp;sspn=2.484787,4.509888&amp;vpsrc=0&amp;hnear=Saint-Ours,+Le+Bas-Richelieu,+Qu%C3%A9bec,+Canada&amp;t=p&amp;hq=&amp;ll=45.8826,-73.13427&amp;spn=0.071699,0.102997&amp;z=5&amp;iwloc=A&amp;output=embed"></iframe><br /><small><a href="http://maps.google.com/maps?q=Saint-Ours,+QC+J0G+1P0,+Canada&amp;hl=fr&amp;ie=UTF8&amp;sll=46.1532,-72.69104&amp;sspn=2.484787,4.509888&amp;vpsrc=0&amp;hnear=Saint-Ours,+Le+Bas-Richelieu,+Qu%C3%A9bec,+Canada&amp;t=p&amp;hq=&amp;ll=45.8826,-73.13427&amp;spn=0.071699,0.102997&amp;z=5&amp;iwloc=A&amp;source=embed" style="text-align:left">Agrandir le plan</a></small>
				</div>
				<h3><?php echo $Tr_coord; ?></h3>
				<table summary="Coordinates">
					<tr>
            <td><strong><?php echo $Tr_longitude; ?> :</strong></td>
            <td><?php echo $longitude; ?></td>
          </tr><tr>
            <td><strong><?php echo $Tr_latitude; ?> :</strong></td>
            <td><?php echo $latitude; ?></td>
          </tr>
				</table>
				<h3><?php echo $Tr_location; ?></h3>
				<table summary="Location">
          <tr><td><strong><?php echo $Tr_country; ?> :</strong></td>
            <td>Canada</td>
          </tr><tr>
            <td><strong><?php echo $Tr_state; ?> :</strong></td>
            <td>Quebec</td>
          </tr><tr>
            <td><strong><?php echo $Tr_city; ?> :</strong></td>
            <td>St-Ours</td>
          </tr>
				</table>
				<p><em>see this interactive map to locate our town.</em></p>
			</div>
			<div class="boxes" style="height: 185px; padding: 12px 10px 12px 20px;">
				<div style="float: left; width: 55%">
					<h3><?php echo $Tr_station; ?></h3>
					<table style="padding: 0px" summary="Station equipement">
            <tr>
              <td><?php echo $Tr_stationtype.': </td><td>'.$stationtype; ?></td>
            </tr><tr>
              <td><?php echo $Tr_pc.':</td><td>'.$CpuName; ?></td>
            </tr><tr>
              <td>&nbsp;</td><td><?php echo $OsVersion ?></td>
            </tr>
					</table>
				</div>
				<div style="float: right; width: 45%">
					<h3><?php echo $TT_website; ?></h3>
					<p><?php echo $Tr_since.':'.$recordsbegandate; ?></p>
					<p><?php echo $Tr_template; ?>: <a href="http://weatherbyyou.com">Weather by You!</a></p>
					<p><?php echo $Tr_engine.': <a href="http://sandaysoft.com">Cumulus</a> v'.$version.' ('.$build.')'; ?></p>
				</div>
			</div>
		</div>
		<div class="clear"></div>
	</div>
</div>
<div id="bg_btm">
	<div id="footer">
		<p id="footer_notes">Copyright (c) 2014 <a href="http://weatherbyyou.com">Weather by You!</a></p>
	</div>
</div>
</body>
</html>