<?php
$tpl_version = "1.2";
if (isset($_GET['ver'])) {
  echo $tpl_version;
  exit;
	// Date: 2014-12-25
}

session_start(); // start PHP session
// Check if a language has been selected
if (isset($_POST['langue'])) {
  $lang = $_POST['langue'];
  $_SESSION['langue'] = $lang; // store session data
}
elseif(isset($_SESSION['langue'])){
  $lang = $_SESSION['langue']; // Default language
}
else {
  $lang = 'en'; // Default language
  $_SESSION['langue'] = $lang;
}

// Include text and data file
require('lang/text_standard_'.$lang.'.php');
include('wt_data_inc.php');
include('wt_months_inc.php');

// Include language files available in lang folder
include('include/local_lang.php');
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<meta http-equiv="content-type" content="text/html; charset=utf-8" />
	<title><?php echo $location; ?> | Extreme monthly</title>
	<meta name="keywords" content="data collection station forecasts" />
	<meta name="description" content="Summary of the data for the current month" />
	<link type="text/css" rel="stylesheet" href="style.css" />
  <link rel="stylesheet" type="text/css" href="lib/ajaxtabs/ajaxtabs.css" />
  <script type="text/javascript" src="lib/ajaxtabs/ajaxtabs.js"></script>
	<script type="text/javascript">
		var monthnames = new Array("Records for the month of January","Records for the month of February","Records for the month of March","Records for the month of April","Records for the month May","Records for the month June","Records for the month July","Records for the month August","Records for the month September","Records for the month October","Records for the month November","Records for the month December", "<?php echo $TT_records; ?>");
		var hightemp = new Array(<?php echo '"'.$ByMonth01TempH.'","'.$ByMonth02TempH.'","'.$ByMonth03TempH.'","'.$ByMonth04TempH.'","'.$ByMonth05TempH.'","'.$ByMonth06TempH.'","'.$ByMonth07TempH.'","'.$ByMonth08TempH.'","'.$ByMonth09TempH.'","'.$ByMonth10TempH.'","'.$ByMonth11TempH.'","'.$ByMonth12TempH.'","'.$tempH.'"'; ?>);
		var hightempT = new Array(<?php echo '"'.$ByMonth01TempHTF.'","'.$ByMonth02TempHTF.'","'.$ByMonth03TempHTF.'","'.$ByMonth04TempHTF.'","'.$ByMonth05TempHTF.'","'.$ByMonth06TempHTF.'","'.$ByMonth07TempHTF.'","'.$ByMonth08TempHTF.'","'.$ByMonth09TempHTF.'","'.$ByMonth10TempHTF.'","'.$ByMonth11TempHTF.'","'.$ByMonth12TempHTF.'","'.$TtempHF.'"'; ?>);
		var lowtemp = new Array(<?php echo '"'.$ByMonth01TempL.'","'.$ByMonth02TempL.'","'.$ByMonth03TempL.'","'.$ByMonth04TempL.'","'.$ByMonth05TempL.'","'.$ByMonth06TempL.'","'.$ByMonth07TempL.'","'.$ByMonth08TempL.'","'.$ByMonth09TempL.'","'.$ByMonth10TempL.'","'.$ByMonth11TempL.'","'.$ByMonth12TempL.'","'.$tempL.'"'; ?>);
		var lowtempT = new Array(<?php echo '"'.$ByMonth01TempLTF.'","'.$ByMonth02TempLTF.'","'.$ByMonth03TempLTF.'","'.$ByMonth04TempLTF.'","'.$ByMonth05TempLTF.'","'.$ByMonth06TempLTF.'","'.$ByMonth07TempLTF.'","'.$ByMonth08TempLTF.'","'.$ByMonth09TempLTF.'","'.$ByMonth10TempLTF.'","'.$ByMonth11TempLTF.'","'.$ByMonth12TempLTF.'","'.$TtempLF.'"'; ?>);
		var highDP = new Array(<?php echo '"'.$ByMonth01DewPointH.'","'.$ByMonth02DewPointH.'","'.$ByMonth03DewPointH.'","'.$ByMonth04DewPointH.'","'.$ByMonth05DewPointH.'","'.$ByMonth06DewPointH.'","'.$ByMonth07DewPointH.'","'.$ByMonth08DewPointH.'","'.$ByMonth09DewPointH.'","'.$ByMonth10DewPointH.'","'.$ByMonth11DewPointH.'","'.$ByMonth12DewPointH.'","'.$dewpointH.'"'; ?>);
		var highDPT = new Array(<?php echo '"'.$ByMonth01DewPointHTF.'","'.$ByMonth02DewPointHTF.'","'.$ByMonth03DewPointHTF.'","'.$ByMonth04DewPointHTF.'","'.$ByMonth05DewPointHTF.'","'.$ByMonth06DewPointHTF.'","'.$ByMonth07DewPointHTF.'","'.$ByMonth08DewPointHTF.'","'.$ByMonth09DewPointHTF.'","'.$ByMonth10DewPointHTF.'","'.$ByMonth11DewPointHTF.'","'.$ByMonth12DewPointHTF.'","'.$TdewpointHF.'"'; ?>);
		var lowDP = new Array(<?php echo '"'.$ByMonth01DewPointL.'","'.$ByMonth02DewPointL.'","'.$ByMonth03DewPointL.'","'.$ByMonth04DewPointL.'","'.$ByMonth05DewPointL.'","'.$ByMonth06DewPointL.'","'.$ByMonth07DewPointL.'","'.$ByMonth08DewPointL.'","'.$ByMonth09DewPointL.'","'.$ByMonth10DewPointL.'","'.$ByMonth11DewPointL.'","'.$ByMonth12DewPointL.'","'.$dewpointL.'"'; ?>);
		var lowDPT = new Array(<?php echo '"'.$ByMonth01DewPointLTF.'","'.$ByMonth02DewPointLTF.'","'.$ByMonth03DewPointLTF.'","'.$ByMonth04DewPointLTF.'","'.$ByMonth05DewPointLTF.'","'.$ByMonth06DewPointLTF.'","'.$ByMonth07DewPointLTF.'","'.$ByMonth08DewPointLTF.'","'.$ByMonth09DewPointLTF.'","'.$ByMonth10DewPointLTF.'","'.$ByMonth11DewPointLTF.'","'.$ByMonth12DewPointLTF.'","'.$TdewpointLF.'"'; ?>);
		var highapptemp = new Array(<?php echo '"'.$ByMonth01AppTempH.'","'.$ByMonth02AppTempH.'","'.$ByMonth03AppTempH.'","'.$ByMonth04AppTempH.'","'.$ByMonth05AppTempH.'","'.$ByMonth06AppTempH.'","'.$ByMonth07AppTempH.'","'.$ByMonth08AppTempH.'","'.$ByMonth09AppTempH.'","'.$ByMonth10AppTempH.'","'.$ByMonth11AppTempH.'","'.$ByMonth12AppTempH.'","'.$apptempH.'"'; ?>);
		var highapptempT = new Array(<?php echo '"'.$ByMonth01AppTempHTF.'","'.$ByMonth02AppTempHTF.'","'.$ByMonth03AppTempHTF.'","'.$ByMonth04AppTempHTF.'","'.$ByMonth05AppTempHTF.'","'.$ByMonth06AppTempHTF.'","'.$ByMonth07AppTempHTF.'","'.$ByMonth08AppTempHTF.'","'.$ByMonth09AppTempHTF.'","'.$ByMonth10AppTempHTF.'","'.$ByMonth11AppTempHTF.'","'.$ByMonth12AppTempHTF.'","'.$TapptempHF.'"'; ?>);
		var lowapptemp = new Array(<?php echo '"'.$ByMonth01AppTempL.'","'.$ByMonth02AppTempL.'","'.$ByMonth03AppTempL.'","'.$ByMonth04AppTempL.'","'.$ByMonth05AppTempL.'","'.$ByMonth06AppTempL.'","'.$ByMonth07AppTempL.'","'.$ByMonth08AppTempL.'","'.$ByMonth09AppTempL.'","'.$ByMonth10AppTempL.'","'.$ByMonth11AppTempL.'","'.$ByMonth12AppTempL.'","'.$apptempL.'"'; ?>);
		var lowapptempT = new Array(<?php echo '"'.$ByMonth01AppTempLTF.'","'.$ByMonth02AppTempLTF.'","'.$ByMonth03AppTempLTF.'","'.$ByMonth04AppTempLTF.'","'.$ByMonth05AppTempLTF.'","'.$ByMonth06AppTempLTF.'","'.$ByMonth07AppTempLTF.'","'.$ByMonth08AppTempLTF.'","'.$ByMonth09AppTempLTF.'","'.$ByMonth10AppTempLTF.'","'.$ByMonth11AppTempLTF.'","'.$ByMonth12AppTempLTF.'","'.$TapptempLF.'"'; ?>);
		var lowchill = new Array(<?php echo '"'.$ByMonth01WChillL.'","'.$ByMonth02WChillL.'","'.$ByMonth03WChillL.'","'.$ByMonth04WChillL.'","'.$ByMonth05WChillL.'","'.$ByMonth06WChillL.'","'.$ByMonth07WChillL.'","'.$ByMonth08WChillL.'","'.$ByMonth09WChillL.'","'.$ByMonth10WChillL.'","'.$ByMonth11WChillL.'","'.$ByMonth12WChillL.'","'.$wchillH.'"'; ?>);
		var lowchillT = new Array(<?php echo '"'.$ByMonth01WChillLTF.'","'.$ByMonth02WChillLTF.'","'.$ByMonth03WChillLTF.'","'.$ByMonth04WChillLTF.'","'.$ByMonth05WChillLTF.'","'.$ByMonth06WChillLTF.'","'.$ByMonth07WChillLTF.'","'.$ByMonth08WChillLTF.'","'.$ByMonth09WChillLTF.'","'.$ByMonth10WChillLTF.'","'.$ByMonth11WChillLTF.'","'.$ByMonth12WChillLTF.'","'.$TwchillHF.'"'; ?>);
		var highheatindex = new Array(<?php echo '"'.$ByMonth01HeatIndexH.'","'.$ByMonth02HeatIndexH.'","'.$ByMonth03HeatIndexH.'","'.$ByMonth04HeatIndexH.'","'.$ByMonth05HeatIndexH.'","'.$ByMonth06HeatIndexH.'","'.$ByMonth07HeatIndexH.'","'.$ByMonth08HeatIndexH.'","'.$ByMonth09HeatIndexH.'","'.$ByMonth10HeatIndexH.'","'.$ByMonth11HeatIndexH.'","'.$ByMonth12HeatIndexH.'","'.$heatindexH.'"'; ?>);
		var highheatindexT = new Array(<?php echo '"'.$ByMonth01HeatIndexHTF.'","'.$ByMonth02HeatIndexHTF.'","'.$ByMonth03HeatIndexHTF.'","'.$ByMonth04HeatIndexHTF.'","'.$ByMonth05HeatIndexHTF.'","'.$ByMonth06HeatIndexHTF.'","'.$ByMonth07HeatIndexHTF.'","'.$ByMonth08HeatIndexHTF.'","'.$ByMonth09HeatIndexHTF.'","'.$ByMonth10HeatIndexHTF.'","'.$ByMonth11HeatIndexHTF.'","'.$ByMonth12HeatIndexHTF.'","'.$TheatindexHF.'"'; ?>);
		var highmintemp = new Array(<?php echo '"'.$ByMonth01MinTempH.'","'.$ByMonth02MinTempH.'","'.$ByMonth03MinTempH.'","'.$ByMonth04MinTempH.'","'.$ByMonth05MinTempH.'","'.$ByMonth06MinTempH.'","'.$ByMonth07MinTempH.'","'.$ByMonth08MinTempH.'","'.$ByMonth09MinTempH.'","'.$ByMonth10MinTempH.'","'.$ByMonth11MinTempH.'","'.$ByMonth12MinTempH.'","'.$mintempH.'"'; ?>);
		var highmintempT = new Array(<?php echo '"'.$ByMonth01MinTempHTF.'","'.$ByMonth02MinTempHTF.'","'.$ByMonth03MinTempHTF.'","'.$ByMonth04MinTempHTF.'","'.$ByMonth05MinTempHTF.'","'.$ByMonth06MinTempHTF.'","'.$ByMonth07MinTempHTF.'","'.$ByMonth08MinTempHTF.'","'.$ByMonth09MinTempHTF.'","'.$ByMonth10MinTempHTF.'","'.$ByMonth11MinTempHTF.'","'.$ByMonth12MinTempHTF.'","'.$TmintempHF.'"'; ?>);
		var lowmaxtemp = new Array(<?php echo '"'.$ByMonth01MaxTempL.'","'.$ByMonth02MaxTempL.'","'.$ByMonth03MaxTempL.'","'.$ByMonth04MaxTempL.'","'.$ByMonth05MaxTempL.'","'.$ByMonth06MaxTempL.'","'.$ByMonth07MaxTempL.'","'.$ByMonth08MaxTempL.'","'.$ByMonth09MaxTempL.'","'.$ByMonth10MaxTempL.'","'.$ByMonth11MaxTempL.'","'.$ByMonth12MaxTempL.'","'.$maxtempL.'"'; ?>);
		var lowmaxtempT = new Array(<?php echo '"'.$ByMonth01MaxTempLTF.'","'.$ByMonth02MaxTempLTF.'","'.$ByMonth03MaxTempLTF.'","'.$ByMonth04MaxTempLTF.'","'.$ByMonth05MaxTempLTF.'","'.$ByMonth06MaxTempLTF.'","'.$ByMonth07MaxTempLTF.'","'.$ByMonth08MaxTempLTF.'","'.$ByMonth09MaxTempLTF.'","'.$ByMonth10MaxTempLTF.'","'.$ByMonth11MaxTempLTF.'","'.$ByMonth12MaxTempLTF.'","'.$TmaxtempLF.'"'; ?>);
		var highhum = new Array(<?php echo '"'.$ByMonth01HumH.'","'.$ByMonth02HumH.'","'.$ByMonth03HumH.'","'.$ByMonth04HumH.'","'.$ByMonth05HumH.'","'.$ByMonth06HumH.'","'.$ByMonth07HumH.'","'.$ByMonth08HumH.'","'.$ByMonth09HumH.'","'.$ByMonth10HumH.'","'.$ByMonth11HumH.'","'.$ByMonth12HumH.'","'.$humH.'"'; ?>);
		var highhumT = new Array(<?php echo '"'.$ByMonth01HumHTF.'","'.$ByMonth02HumHTF.'","'.$ByMonth03HumHTF.'","'.$ByMonth04HumHTF.'","'.$ByMonth05HumHTF.'","'.$ByMonth06HumHTF.'","'.$ByMonth07HumHTF.'","'.$ByMonth08HumHTF.'","'.$ByMonth09HumHTF.'","'.$ByMonth10HumHTF.'","'.$ByMonth11HumHTF.'","'.$ByMonth12HumHTF.'","'.$ThumHF.'"'; ?>);
		var lowhum = new Array(<?php echo '"'.$ByMonth01HumL.'","'.$ByMonth02HumL.'","'.$ByMonth03HumL.'","'.$ByMonth04HumL.'","'.$ByMonth05HumL.'","'.$ByMonth06HumL.'","'.$ByMonth07HumL.'","'.$ByMonth08HumL.'","'.$ByMonth09HumL.'","'.$ByMonth10HumL.'","'.$ByMonth11HumL.'","'.$ByMonth12HumL.'","'.$humL.'"'; ?>);
		var lowhumT = new Array(<?php echo '"'.$ByMonth01HumLTF.'","'.$ByMonth02HumLTF.'","'.$ByMonth03HumLTF.'","'.$ByMonth04HumLTF.'","'.$ByMonth05HumLTF.'","'.$ByMonth06HumLTF.'","'.$ByMonth07HumLTF.'","'.$ByMonth08HumLTF.'","'.$ByMonth09HumLTF.'","'.$ByMonth10HumLTF.'","'.$ByMonth11HumLTF.'","'.$ByMonth12HumLTF.'","'.$ThumLF.'"'; ?>);
		var hightemprange = new Array(<?php echo '"'.$ByMonth01HighDailyTempRange.'","'.$ByMonth02HighDailyTempRange.'","'.$ByMonth03HighDailyTempRange.'","'.$ByMonth04HighDailyTempRange.'","'.$ByMonth05HighDailyTempRange.'","'.$ByMonth06HighDailyTempRange.'","'.$ByMonth07HighDailyTempRange.'","'.$ByMonth08HighDailyTempRange.'","'.$ByMonth09HighDailyTempRange.'","'.$ByMonth10HighDailyTempRange.'","'.$ByMonth11HighDailyTempRange.'","'.$ByMonth12HighDailyTempRange.'","'.$HighDailyTempRange.'"'; ?>);
		var hightemprangeT = new Array(<?php echo '"'.$ByMonth01HighDailyTempRangeTF.'","'.$ByMonth02HighDailyTempRangeTF.'","'.$ByMonth03HighDailyTempRangeTF.'","'.$ByMonth04HighDailyTempRangeTF.'","'.$ByMonth05HighDailyTempRangeTF.'","'.$ByMonth06HighDailyTempRangeTF.'","'.$ByMonth07HighDailyTempRangeTF.'","'.$ByMonth08HighDailyTempRangeTF.'","'.$ByMonth09HighDailyTempRangeTF.'","'.$ByMonth10HighDailyTempRangeTF.'","'.$ByMonth11HighDailyTempRangeTF.'","'.$ByMonth12HighDailyTempRangeTF.'","'.$HighDailyTempRangeDF.'"'; ?>);
		var lowtemprange = new Array(<?php echo '"'.$ByMonth01LowDailyTempRange.'","'.$ByMonth02LowDailyTempRange.'","'.$ByMonth03LowDailyTempRange.'","'.$ByMonth04LowDailyTempRange.'","'.$ByMonth05LowDailyTempRange.'","'.$ByMonth06LowDailyTempRange.'","'.$ByMonth07LowDailyTempRange.'","'.$ByMonth08LowDailyTempRange.'","'.$ByMonth09LowDailyTempRange.'","'.$ByMonth10LowDailyTempRange.'","'.$ByMonth11LowDailyTempRange.'","'.$ByMonth12LowDailyTempRange.'","'.$LowDailyTempRange.'"'; ?>);
		var lowtemprangeT = new Array(<?php echo '"'.$ByMonth01LowDailyTempRangeTF.'","'.$ByMonth02LowDailyTempRangeTF.'","'.$ByMonth03LowDailyTempRangeTF.'","'.$ByMonth04LowDailyTempRangeTF.'","'.$ByMonth05LowDailyTempRangeTF.'","'.$ByMonth06LowDailyTempRangeTF.'","'.$ByMonth07LowDailyTempRangeTF.'","'.$ByMonth08LowDailyTempRangeTF.'","'.$ByMonth09LowDailyTempRangeTF.'","'.$ByMonth10LowDailyTempRangeTF.'","'.$ByMonth11LowDailyTempRangeTF.'","'.$ByMonth12LowDailyTempRangeTF.'","'.$LowDailyTempRangeDF.'"'; ?>);
		var rainrate = new Array(<?php echo '"'.$ByMonth01RainRateH.'","'.$ByMonth02RainRateH.'","'.$ByMonth03RainRateH.'","'.$ByMonth04RainRateH.'","'.$ByMonth05RainRateH.'","'.$ByMonth06RainRateH.'","'.$ByMonth07RainRateH.'","'.$ByMonth08RainRateH.'","'.$ByMonth09RainRateH.'","'.$ByMonth10RainRateH.'","'.$ByMonth11RainRateH.'","'.$ByMonth12RainRateH.'","'.$rrateM.'"'; ?>);
		var rainrateT = new Array(<?php echo '"'.$ByMonth01RainRateHTF.'","'.$ByMonth02RainRateHTF.'","'.$ByMonth03RainRateHTF.'","'.$ByMonth04RainRateHTF.'","'.$ByMonth05RainRateHTF.'","'.$ByMonth06RainRateHTF.'","'.$ByMonth07RainRateHTF.'","'.$ByMonth08RainRateHTF.'","'.$ByMonth09RainRateHTF.'","'.$ByMonth10RainRateHTF.'","'.$ByMonth11RainRateHTF.'","'.$ByMonth12RainRateHTF.'","'.$TrrateMF.'"'; ?>);
		var hourlyrain = new Array(<?php echo '"'.$ByMonth01HourlyRainH.'","'.$ByMonth02HourlyRainH.'","'.$ByMonth03HourlyRainH.'","'.$ByMonth04HourlyRainH.'","'.$ByMonth05HourlyRainH.'","'.$ByMonth06HourlyRainH.'","'.$ByMonth07HourlyRainH.'","'.$ByMonth08HourlyRainH.'","'.$ByMonth09HourlyRainH.'","'.$ByMonth10HourlyRainH.'","'.$ByMonth11HourlyRainH.'","'.$ByMonth12HourlyRainH.'","'.$rfallhH.'"'; ?>);
		var hourlyrainT = new Array(<?php echo '"'.$ByMonth01HourlyRainHTF.'","'.$ByMonth02HourlyRainHTF.'","'.$ByMonth03HourlyRainHTF.'","'.$ByMonth04HourlyRainHTF.'","'.$ByMonth05HourlyRainHTF.'","'.$ByMonth06HourlyRainHTF.'","'.$ByMonth07HourlyRainHTF.'","'.$ByMonth08HourlyRainHTF.'","'.$ByMonth09HourlyRainHTF.'","'.$ByMonth10HourlyRainHTF.'","'.$ByMonth11HourlyRainHTF.'","'.$ByMonth12HourlyRainHTF.'","'.$TrfallhHF.'"'; ?>);
		var dailyrain = new Array(<?php echo '"'.$ByMonth01DailyRainH.'","'.$ByMonth02DailyRainH.'","'.$ByMonth03DailyRainH.'","'.$ByMonth04DailyRainH.'","'.$ByMonth05DailyRainH.'","'.$ByMonth06DailyRainH.'","'.$ByMonth07DailyRainH.'","'.$ByMonth08DailyRainH.'","'.$ByMonth09DailyRainH.'","'.$ByMonth10DailyRainH.'","'.$ByMonth11DailyRainH.'","'.$ByMonth12DailyRainH.'","'.$rfallH.'"'; ?>);
		var dailyrainT = new Array(<?php echo '"'.$ByMonth01DailyRainHTF.'","'.$ByMonth02DailyRainHTF.'","'.$ByMonth03DailyRainHTF.'","'.$ByMonth04DailyRainHTF.'","'.$ByMonth05DailyRainHTF.'","'.$ByMonth06DailyRainHTF.'","'.$ByMonth07DailyRainHTF.'","'.$ByMonth08DailyRainHTF.'","'.$ByMonth09DailyRainHTF.'","'.$ByMonth10DailyRainHTF.'","'.$ByMonth11DailyRainHTF.'","'.$ByMonth12DailyRainHTF.'","'.$TrfallHF.'"'; ?>);
		var monthlyrain = new Array(<?php echo '"'.$ByMonth01MonthlyRainH.'","'.$ByMonth02MonthlyRainH.'","'.$ByMonth03MonthlyRainH.'","'.$ByMonth04MonthlyRainH.'","'.$ByMonth05MonthlyRainH.'","'.$ByMonth06MonthlyRainH.'","'.$ByMonth07MonthlyRainH.'","'.$ByMonth08MonthlyRainH.'","'.$ByMonth09MonthlyRainH.'","'.$ByMonth10MonthlyRainH.'","'.$ByMonth11MonthlyRainH.'","'.$ByMonth12MonthlyRainH.'","'.$rfallmH.'"'; ?>);
		var monthlyrainT = new Array(<?php echo '"'.$ByMonth01MonthlyRainHTF.'","'.$ByMonth02MonthlyRainHTF.'","'.$ByMonth03MonthlyRainHTF.'","'.$ByMonth04MonthlyRainHTF.'","'.$ByMonth05MonthlyRainHTF.'","'.$ByMonth06MonthlyRainHTF.'","'.$ByMonth07MonthlyRainHTF.'","'.$ByMonth08MonthlyRainHTF.'","'.$ByMonth09MonthlyRainHTF.'","'.$ByMonth10MonthlyRainHTF.'","'.$ByMonth11MonthlyRainHTF.'","'.$ByMonth12MonthlyRainHTF.'","'.$TrfallmHF.'"'; ?>);
		var dryperiod = new Array(<?php echo '"'.$ByMonth01LongestDryPeriod.'","'.$ByMonth02LongestDryPeriod.'","'.$ByMonth03LongestDryPeriod.'","'.$ByMonth04LongestDryPeriod.'","'.$ByMonth05LongestDryPeriod.'","'.$ByMonth06LongestDryPeriod.'","'.$ByMonth07LongestDryPeriod.'","'.$ByMonth08LongestDryPeriod.'","'.$ByMonth09LongestDryPeriod.'","'.$ByMonth10LongestDryPeriod.'","'.$ByMonth11LongestDryPeriod.'","'.$ByMonth12LongestDryPeriod.'","'.$LongestDryPeriod.'"'; ?>);
		var dryperiodT = new Array(<?php echo '"'.$ByMonth01LongestDryPeriodTF.'","'.$ByMonth02LongestDryPeriodTF.'","'.$ByMonth03LongestDryPeriodTF.'","'.$ByMonth04LongestDryPeriodTF.'","'.$ByMonth05LongestDryPeriodTF.'","'.$ByMonth06LongestDryPeriodTF.'","'.$ByMonth07LongestDryPeriodTF.'","'.$ByMonth08LongestDryPeriodTF.'","'.$ByMonth09LongestDryPeriodTF.'","'.$ByMonth10LongestDryPeriodTF.'","'.$ByMonth11LongestDryPeriodTF.'","'.$ByMonth12LongestDryPeriodTF.'","'.$TLongestDryPeriodF.'"'; ?>);
		var wetperiod = new Array(<?php echo '"'.$ByMonth01LongestWetPeriod.'","'.$ByMonth02LongestWetPeriod.'","'.$ByMonth03LongestWetPeriod.'","'.$ByMonth04LongestWetPeriod.'","'.$ByMonth05LongestWetPeriod.'","'.$ByMonth06LongestWetPeriod.'","'.$ByMonth07LongestWetPeriod.'","'.$ByMonth08LongestWetPeriod.'","'.$ByMonth09LongestWetPeriod.'","'.$ByMonth10LongestWetPeriod.'","'.$ByMonth11LongestWetPeriod.'","'.$ByMonth12LongestWetPeriod.'","'.$LongestWetPeriod.'"'; ?>);
		var wetperiodT = new Array(<?php echo '"'.$ByMonth01LongestWetPeriodTF.'","'.$ByMonth02LongestWetPeriodTF.'","'.$ByMonth03LongestWetPeriodTF.'","'.$ByMonth04LongestWetPeriodTF.'","'.$ByMonth05LongestWetPeriodTF.'","'.$ByMonth06LongestWetPeriodTF.'","'.$ByMonth07LongestWetPeriodTF.'","'.$ByMonth08LongestWetPeriodTF.'","'.$ByMonth09LongestWetPeriodTF.'","'.$ByMonth10LongestWetPeriodTF.'","'.$ByMonth11LongestWetPeriodTF.'","'.$ByMonth12LongestWetPeriodTF.'","'.$TLongestWetPeriodF.'"'; ?>);
		var highgust = new Array(<?php echo '"'.$ByMonth01GustH.'","'.$ByMonth02GustH.'","'.$ByMonth03GustH.'","'.$ByMonth04GustH.'","'.$ByMonth05GustH.'","'.$ByMonth06GustH.'","'.$ByMonth07GustH.'","'.$ByMonth08GustH.'","'.$ByMonth09GustH.'","'.$ByMonth10GustH.'","'.$ByMonth11GustH.'","'.$ByMonth12GustH.'","'.$gustM.'"'; ?>);
		var highgustT = new Array(<?php echo '"'.$ByMonth01GustHTF.'","'.$ByMonth02GustHTF.'","'.$ByMonth03GustHTF.'","'.$ByMonth04GustHTF.'","'.$ByMonth05GustHTF.'","'.$ByMonth06GustHTF.'","'.$ByMonth07GustHTF.'","'.$ByMonth08GustHTF.'","'.$ByMonth09GustHTF.'","'.$ByMonth10GustHTF.'","'.$ByMonth11GustHTF.'","'.$ByMonth12GustHTF.'","'.$TgustMF.'"'; ?>);
		var highwind = new Array(<?php echo '"'.$ByMonth01WindH.'","'.$ByMonth02WindH.'","'.$ByMonth03WindH.'","'.$ByMonth04WindH.'","'.$ByMonth05WindH.'","'.$ByMonth06WindH.'","'.$ByMonth07WindH.'","'.$ByMonth08WindH.'","'.$ByMonth09WindH.'","'.$ByMonth10WindH.'","'.$ByMonth11WindH.'","'.$ByMonth12WindH.'","'.$wspeedH.'"'; ?>);
		var highwindT = new Array(<?php echo '"'.$ByMonth01WindHTF.'","'.$ByMonth02WindHTF.'","'.$ByMonth03WindHTF.'","'.$ByMonth04WindHTF.'","'.$ByMonth05WindHTF.'","'.$ByMonth06WindHTF.'","'.$ByMonth07WindHTF.'","'.$ByMonth08WindHTF.'","'.$ByMonth09WindHTF.'","'.$ByMonth10WindHTF.'","'.$ByMonth11WindHTF.'","'.$ByMonth12WindHTF.'","'.$TwspeedHF.'"'; ?>);
		var highwindrun = new Array(<?php echo '"'.$ByMonth01WindRunH.'","'.$ByMonth02WindRunH.'","'.$ByMonth03WindRunH.'","'.$ByMonth04WindRunH.'","'.$ByMonth05WindRunH.'","'.$ByMonth06WindRunH.'","'.$ByMonth07WindRunH.'","'.$ByMonth08WindRunH.'","'.$ByMonth09WindRunH.'","'.$ByMonth10WindRunH.'","'.$ByMonth11WindRunH.'","'.$ByMonth12WindRunH.'","'.$windrunH.'"'; ?>);
		var highwindrunT = new Array(<?php echo '"'.$ByMonth01WindRunHTF.'","'.$ByMonth02WindRunHTF.'","'.$ByMonth03WindRunHTF.'","'.$ByMonth04WindRunHTF.'","'.$ByMonth05WindRunHTF.'","'.$ByMonth06WindRunHTF.'","'.$ByMonth07WindRunHTF.'","'.$ByMonth08WindRunHTF.'","'.$ByMonth09WindRunHTF.'","'.$ByMonth10WindRunHTF.'","'.$ByMonth11WindRunHTF.'","'.$ByMonth12WindRunHTF.'","'.$TwindrunHF.'"'; ?>);
		var highpress = new Array(<?php echo '"'.$ByMonth01PressH.'","'.$ByMonth02PressH.'","'.$ByMonth03PressH.'","'.$ByMonth04PressH.'","'.$ByMonth05PressH.'","'.$ByMonth06PressH.'","'.$ByMonth07PressH.'","'.$ByMonth08PressH.'","'.$ByMonth09PressH.'","'.$ByMonth10PressH.'","'.$ByMonth11PressH.'","'.$ByMonth12PressH.'","'.$pressH.'"'; ?>);
		var highpressT = new Array(<?php echo '"'.$ByMonth01PressHTF.'","'.$ByMonth02PressHTF.'","'.$ByMonth03PressHTF.'","'.$ByMonth04PressHTF.'","'.$ByMonth05PressHTF.'","'.$ByMonth06PressHTF.'","'.$ByMonth07PressHTF.'","'.$ByMonth08PressHTF.'","'.$ByMonth09PressHTF.'","'.$ByMonth10PressHTF.'","'.$ByMonth11PressHTF.'","'.$ByMonth12PressHTF.'","'.$TpressHF.'"'; ?>);
		var lowpress = new Array(<?php echo '"'.$ByMonth01PressL.'","'.$ByMonth02PressL.'","'.$ByMonth03PressL.'","'.$ByMonth04PressL.'","'.$ByMonth05PressL.'","'.$ByMonth06PressL.'","'.$ByMonth07PressL.'","'.$ByMonth08PressL.'","'.$ByMonth09PressL.'","'.$ByMonth10PressL.'","'.$ByMonth11PressL.'","'.$ByMonth12PressL.'","'.$pressL.'"'; ?>);
		var lowpressT = new Array(<?php echo '"'.$ByMonth01PressLTF.'","'.$ByMonth02PressLTF.'","'.$ByMonth03PressLTF.'","'.$ByMonth04PressLTF.'","'.$ByMonth05PressLTF.'","'.$ByMonth06PressLTF.'","'.$ByMonth07PressLTF.'","'.$ByMonth08PressLTF.'","'.$ByMonth09PressLTF.'","'.$ByMonth10PressLTF.'","'.$ByMonth11PressLTF.'","'.$ByMonth12PressLTF.'","'.$TpressLF.'"'; ?>);
		function changeData(month) {
			document.getElementById('MonthName').innerHTML = monthnames[month];
			document.getElementById('TempH').innerHTML = hightemp[month];
			document.getElementById('TempHT').innerHTML = hightempT[month];
			document.getElementById('TempL').innerHTML = lowtemp[month];
			document.getElementById('TempLT').innerHTML = lowtempT[month];
			document.getElementById('DewPointH').innerHTML = highDP[month];
			document.getElementById('DewPointHT').innerHTML = highDPT[month];
			document.getElementById('DewPointL').innerHTML = lowDP[month];
			document.getElementById('DewPointLT').innerHTML = lowDPT[month];
			document.getElementById('AppTempH').innerHTML = highapptemp[month];
			document.getElementById('AppTempHT').innerHTML = highapptempT[month];
			document.getElementById('AppTempL').innerHTML = lowapptemp[month];
			document.getElementById('AppTempLT').innerHTML = lowapptempT[month];
			document.getElementById('WChillL').innerHTML = lowchill[month];
			document.getElementById('WChillLT').innerHTML = lowchillT[month];
			document.getElementById('HeatIndexH').innerHTML = highheatindex[month];
			document.getElementById('HeatIndexHT').innerHTML = highheatindexT[month];
			document.getElementById('MinTempH').innerHTML = highmintemp[month];
			document.getElementById('MinTempHT').innerHTML = highmintempT[month];
			document.getElementById('MaxTempL').innerHTML = lowmaxtemp[month];
			document.getElementById('MaxTempLT').innerHTML = lowmaxtempT[month];
			document.getElementById('HumH').innerHTML = highhum[month];
			document.getElementById('HumHT').innerHTML = highhumT[month];
			document.getElementById('HumL').innerHTML = lowhum[month];
			document.getElementById('HumLT').innerHTML = lowhumT[month];
			document.getElementById('HighDailyTempRange').innerHTML = hightemprange[month];
			document.getElementById('HighDailyTempRangeT').innerHTML = hightemprangeT[month];
			document.getElementById('LowDailyTempRange').innerHTML = lowtemprange[month];
			document.getElementById('LowDailyTempRangeT').innerHTML = lowtemprangeT[month];
			document.getElementById('RainRateH').innerHTML = rainrate[month];
			document.getElementById('RainRateHT').innerHTML = rainrateT[month];
			document.getElementById('HourlyRainH').innerHTML = hourlyrain[month];
			document.getElementById('HourlyRainHT').innerHTML = hourlyrainT[month];
			document.getElementById('DailyRainH').innerHTML = dailyrain[month];
			document.getElementById('DailyRainHT').innerHTML = dailyrainT[month];
			document.getElementById('MonthlyRainH').innerHTML = monthlyrain[month];
			document.getElementById('MonthlyRainHT').innerHTML = monthlyrainT[month];
			document.getElementById('LongestDryPeriod').innerHTML = dryperiod[month];
			document.getElementById('LongestDryPeriodT').innerHTML = dryperiodT[month];
			document.getElementById('LongestWetPeriod').innerHTML = wetperiod[month];
			document.getElementById('LongestWetPeriodT').innerHTML = wetperiodT[month];
			document.getElementById('GustH').innerHTML = highgust[month];
			document.getElementById('GustHT').innerHTML = highgustT[month];
			document.getElementById('WindH').innerHTML = highwind[month];
			document.getElementById('WindHT').innerHTML = highwindT[month];
			document.getElementById('WindRunH').innerHTML = highwindrun[month];
			document.getElementById('WindRunHT').innerHTML = highwindrunT[month];
			document.getElementById('PressL').innerHTML = lowpress[month];
			document.getElementById('PressLT').innerHTML = lowpressT[month];
			document.getElementById('PressH').innerHTML = highpress[month];
			document.getElementById('PressHT').innerHTML = highpressT[month];
		}
		var dayname = new Array ('<?php echo $Tr_sun."','".$Tr_mon."','".$Tr_tue."','".$Tr_wed."','".$Tr_thu."','".$Tr_fri."','".$Tr_sat; ?>');
		var monthname = new Array ('<?php echo $Tr_jan."','".$Tr_feb."','".$Tr_mar."','".$Tr_apr."','".$Tr_may."','".$Tr_jun."','".$Tr_jul."','".$Tr_aug."','".$Tr_sep."','".$Tr_oct."','".$Tr_nov."','".$Tr_dec; ?>');	
	</script>
</head>
<body>
<div id="header">
	<div id="title">
		<h1>Weather Sunset</h1>
		<p><span>by Weather by You!</span></p>
	</div>
	<div id="top_menu">
		<ul>
			<!-- Menu item in inverted order, due to float -->
			<li><a href="system.php">System</a></li>
			<li><a href="infos.php">About</a></li>
			<li><a href="images.php">Images</a></li>
			<li><a href="ss_gauges.php">Gauges</a></li>
			<li><a href="index.php">Home</a></li>
		</ul>
	</div>
</div>
<div id="base">
  <!-- Right Column -->
	<div id="sidebar">
		<div class="sidebar2">
			<div id="select_lang">
			<?php
				if (isset($nb_langues)) {
			?>
      <form id="lang_sel" method="post" action="<?php echo $_SERVER['PHP_SELF']; ?>">
        <h2 style="padding: 0px">Language:</h2>
        <p><select name="langue" class="styled" title="Select one" onchange="document.forms[0].submit();return false;">
          <?php
            $inc = 0;
            while($inc < $nb_langues) {
              if($languages[$inc][0] == $lang)
                echo '<option value="'.$languages[$inc][0].'" selected="selected">'.$languages[$inc][1].'</option>'."\n";
              else
                echo '<option value="'.$languages[$inc][0].'">'.$languages[$inc][1].'</option>'."\n";
              $inc = $inc + 1;
            }
          ?>
        </select></p>
      </form>  
			<?php
				}
			?>
			</div>
			<div id="calendar">
				<script type="text/javascript">
					var timestamp = new Date();
					var date_yyyy = timestamp.getFullYear();
					var date_mmm = timestamp.getMonth();
					var date_dd = timestamp.getDate();
					var date_day = timestamp.getDay();
				</script>
				<span class="time_month"><script type="text/javascript">document.write(date_yyyy);</script><br />
				<script type="text/javascript">document.write(monthname[date_mmm]);</script></span>
				<h3 style="margin: 15px 0px 8px 0px"><script type="text/javascript">document.write(date_dd);</script></h3>
				<p style="margin: 0px;padding: 0px"><script type="text/javascript">document.write(dayname[date_day]);</script></p>
			</div>
			<br />
			<h2 class="title" style="text-align: center"><?php echo $Tr_currcond; ?></h2>
			<div id="observ" class="side_flip">
				<table style="color:#C2AE7D" summary="Most recent observations">
				<tr>
					<td style="text-align:right"><?php echo $now_temp; ?>:</td>
					<td style="text-align:left"><strong><?php echo $temp; ?></strong><small><?php echo $tempunit; ?></small></td>
				</tr><tr>
					<td style="text-align:right"><?php echo $now_hum; ?>:</td>
					<td style="text-align:left"><strong><?php echo $hum; ?></strong><small>%</small></td>
				</tr><tr>
					<td style="text-align:right"><?php echo $Tr_wind; ?>:</td>
					<td style="text-align:left"><strong><?php echo $wspeed; ?></strong> <small><?php echo $windunit; ?></small></td>
				</tr><tr>
					<td style="text-align:right"><?php echo $Tr_windd; ?>:</td>
					<td style="text-align:left"><strong><?php echo $currentwdir; ?></strong></td></tr>
				</table>
				<p style="text-align: center"><em>Last read at <?php echo $timehhmmss; ?></em></p>
			</div>
			<div class="side_flip">
				<h2 style="padding: 10px 0px 0px 0px">Forecast image</h2>
				<p style="margin: 5px"><em>(for&nbsp;next&nbsp;12&nbsp;hours)</em></p>
				<p><img src="style/forecast/forecast_<?php echo $IsFreezing.'_'.$isdaylight.'_'.$forecastnumber; ?>.png" alt="<?php echo $Tr_forecast.': '.$forecast; ?>" title="<?php echo $Tr_forecast.': '.$forecast; ?>" /></p>
				<br />
			</div>
			<div id="moon_box">
				<h2><?php echo $Tr_moonphase; ?></h2>
				<p><img src="images/moon.bmp" alt="Moon icon" title="Moon icon" /></p>
				<p>Phase : <strong><?php echo $moonphase; ?></strong><br /><?php echo $Tr_MoonPercent; ?> <strong><?php echo $MoonPercentAbs; ?>%</strong></p>
			</div>
		</div>
    <div id="sidebar-credit">
			Design <a href="http://wptemplates.org/" title="Wordpress Themes">Wp Templates</a>.<p> and <a href="http://www.thoughtmechanics.com/chicago-web-design-company/" title="Designed By TM">Designed By TM</a>.</p>
		</div>
	</div>
  <!-- Centre  -->
	<div id="base_header">
		<h1 id="MonthName" style="text-align: center">Records for the month of January</h1>
	</div>
	<div id="wrap">
		<div id="menubar">
			<div class="crosscol section" id="crosscol" style="">
				<div id="PageList1" class="PageList" style="width:650px;margin-left: 50px;">
					<ul id="menuprin" style="top: 0px; margin-left: 50px">
						<li><a href="#" onclick="changeData(0)"><?php echo $Tr_jan; ?></a></li>
						<li><a href="#" onclick="changeData(1)"><?php echo $Tr_feb; ?></a></li>
						<li><a href="#" onclick="changeData(2)"><?php echo $Tr_mar; ?></a></li>
						<li><a href="#" onclick="changeData(3)"><?php echo $Tr_apr; ?></a></li>
						<li><a href="#" onclick="changeData(4)"><?php echo $Tr_may; ?></a></li>
						<li><a href="#" onclick="changeData(5)"><?php echo $Tr_jun; ?></a></li>
					</ul>
				</div>
				<div id="PageList2" class="PageList" style="width:750px;margin-left: 50px;">
					<ul>
						<li><a href="#" onclick="changeData(6)"><?php echo $Tr_jul; ?></a></li>
						<li><a href="#" onclick="changeData(7)"><?php echo $Tr_aug; ?></a></li>
						<li><a href="#" onclick="changeData(8)"><?php echo $Tr_sep; ?></a></li>
						<li><a href="#" onclick="changeData(9)"><?php echo $Tr_oct; ?></a></li>
						<li><a href="#" onclick="changeData(10)"><?php echo $Tr_nov; ?></a></li>
						<li><a href="#" onclick="changeData(11)"><?php echo $Tr_dec; ?></a></li>
						<li><a href="#" onclick="changeData(12)">All Time</a></li>
					</ul>
				</div>
        <div class="clear"></div>
			</div>
		</div>
		<div id="content_top" style="margin-top:81px;"></div>
		<div id="content">
		<!-- WEATHER DATA BEGIN -->
			<div id="inner">
				<p><em><?php echo $Tr_recordsbegandate.' '.$recordsbegandate.'. '.$Tr_recorbd_text; ?></em></p>
				<?php
					include('multirecords_txt.php');
				?>
				<br />
				<p class="credits" style="margin-left:-10px">
					<?php echo $Tr_update.' : '.$update.'<br />'.$Tr_version; ?>
					<a href="http://sandaysoft.com/products/cumulus">Cumulus</a> <?php echo $version.' ('.$build.')'; ?>
				</p>
			</div>
		</div>
		<div class="clear"></div>
	</div>
</div>
<div id="bg_btm">
	<div id="footer">
		<p id="footer_notes">Copyright (c) 2014 <a href="http://weatherbyyou.com">Weather by You!</a></p>
	</div>
</div>
<script type="text/javascript">
	cur_month = <?php echo $month-1; ?>;
	changeData(cur_month, "mon"+cur_month)
</script>
</body>
</html>