<?php
$tpl_version = "1.1";
if (isset($_GET['ver'])) {
  echo $tpl_version;
  exit;
	// Date: 2014-12-25
}

session_start(); // start PHP session
// Check if a language has been selected
if (isset($_POST['langue'])) {
  $lang = $_POST['langue'];
  $_SESSION['langue'] = $lang; // store session data
}
elseif(isset($_SESSION['langue'])){
  $lang = $_SESSION['langue']; // Default language
}
else {
  $lang = 'en'; // Default language
  $_SESSION['langue'] = $lang;
}

// Include text and data file
require('lang/text_standard_'.$lang.'.php');
include('wt_data_inc.php');

// Include language files available in lang folder
include('include/local_lang.php');
?>
<!DOCTYPE html>
<!-- gauges-ssT.htm - Updated: 25 September 2012 -->
<html lang="en">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
	<title><?php echo $location; ?> Weather Sunset template</title>
	<meta name="keywords" content="Current, actually, last minute" />
	<meta name="description" content="Current weather observations" />
	<link type="text/css" rel="stylesheet" href="style.css" />
  <link rel="stylesheet" type="text/css" href="lib/ajaxtabs/ajaxtabs.css" />
  <link rel="stylesheet" href="lib/steelseries/gauges-ss.css">
  <script type="text/javascript" src="lib/ajaxtabs/ajaxtabs.js"></script>
	<script type="text/javascript">
		var dayname = new Array ('<?php echo $Tr_sun."','".$Tr_mon."','".$Tr_tue."','".$Tr_wed."','".$Tr_thu."','".$Tr_fri."','".$Tr_sat; ?>');
		var monthname = new Array ('<?php echo $Tr_jan."','".$Tr_feb."','".$Tr_mar."','".$Tr_apr."','".$Tr_may."','".$Tr_jun."','".$Tr_jul."','".$Tr_aug."','".$Tr_sep."','".$Tr_oct."','".$Tr_nov."','".$Tr_dec; ?>');	
	</script>
</head>
<body>
<div id="header">
	<div id="title">
		<h1>Weather Sunset</h1>
		<p><span>by Weather by You!</span></p>
	</div>
	<div id="top_menu">
		<ul>
			<!-- Menu item in inverted order, due to float -->
			<li><a href="system.php">System</a></li>
			<li><a href="infos.php">About</a></li>
			<li><a href="images.php">Images</a></li>
			<li><a href="ss_gauges.php">Gauges</a></li>
			<li><a href="index.php">Home</a></li>
		</ul>
	</div>
</div>
<div id="base">
  <!-- Right Column -->
	<div id="sidebar">
		<div class="sidebar2">
			<div id="select_lang">
			<?php
				if (isset($nb_langues)) {
			?>
      <form id="lang_sel" method="post" action="<?php echo $_SERVER['PHP_SELF']; ?>">
        <h2 style="padding: 0px">Language:</h2>
        <p><select name="langue" class="styled" title="Select one" onchange="document.forms[0].submit();return false;">
          <?php
            $inc = 0;
            while($inc < $nb_langues) {
              if($languages[$inc][0] == $lang)
                echo '<option value="'.$languages[$inc][0].'" selected="selected">'.$languages[$inc][1].'</option>'."\n";
              else
                echo '<option value="'.$languages[$inc][0].'">'.$languages[$inc][1].'</option>'."\n";
              $inc = $inc + 1;
            }
          ?>
        </select></p>
      </form>  
			<?php
				}
			?>
			</div>
			<div id="calendar">
				<script type="text/javascript">
					var timestamp = new Date();
					var date_yyyy = timestamp.getFullYear();
					var date_mmm = timestamp.getMonth();
					var date_dd = timestamp.getDate();
					var date_day = timestamp.getDay();
				</script>
				<span class="time_month"><script type="text/javascript">document.write(date_yyyy);</script><br />
				<script type="text/javascript">document.write(monthname[date_mmm]);</script></span>
				<h3 style="margin: 15px 0px 8px 0px"><script type="text/javascript">document.write(date_dd);</script></h3>
				<p style="margin: 0px;padding: 0px"><script type="text/javascript">document.write(dayname[date_day]);</script></p>
				<div class="clear"></div>
			</div>
			<div class="sidebar2 section" style="height: 75px;">
				<p>&nbsp;</p>
			</div>
			<div id="observ" style="height: 150px; padding-top:75px">
				<h2 class="title">Other temperature</h2>
				<table style="color:#C2AE7D">
				<tr>
					<td style="text-align:right"><input id="rad_dew1" type="radio" name="rad_dew" value="dew" onclick="gauges.doDew(this);"></td>
					<td style="text-align:left"><label id="lab_dew1" for="rad_dew1">Dew Point</label></td>
				</tr><tr>
					<td style="text-align:right"><input id="rad_dew3" type="radio" name="rad_dew" value="wnd" onclick="gauges.doDew(this);"></td>
					<td style="text-align:left"><label id="lab_dew3" for="rad_dew3">Wind Chill</label></td>
				</tr><tr>
					<td style="text-align:right"><input id="rad_dew2" type="radio" name="rad_dew" value="app" checked onclick="gauges.doDew(this);"></td>
					<td style="text-align:left"><label id="lab_dew2" for="rad_dew2">Apparent</label></td>
				</tr><tr>
					<td style="text-align:right"><input id="rad_dew4" type="radio" name="rad_dew" value="hea" onclick="gauges.doDew(this);"></td>
					<td style="text-align:left"><label id="lab_dew4" for="rad_dew4">Heat Index</label></td>
				</tr><tr>
					<td style="text-align:right"><input id="rad_dew5" type="radio" name="rad_dew" value="hum" onclick="gauges.doDew(this);"></td>
					<td style="text-align:left"><label id="lab_dew5" for="rad_dew5"><?php echo $Tr_humidex; ?></label></td>
				</tr>
				</table>
			</div>
			<div class="sidebar2 section" style="height: 50px; margin-bottom: 20px;">
				<p>&nbsp;</p>
			</div>
			<h2>Weather units</h2>

			<div id="units_select">
				<h3 id="temperature"><span id="lang_temperature"><?php echo $now_temp; ?></span>:</h3>
				<div class="tbl_row">
					<div class="tbl_cell">
						<input id="rad_unitsTemp1" type="radio" name="rad_unitsTemp" value="C" checked onclick="gauges.setUnits(this);"><label id="lab_unitsTemp1" for="rad_unitsTemp1">&deg;C&nbsp;&nbsp;</label>
					</div>
					<div class="tbl_cell">
						<input id="rad_unitsTemp2" type="radio" name="rad_unitsTemp" value="F" onclick="gauges.setUnits(this);"><label id="lab_unitsTemp2" for="rad_unitsTemp2">&deg;F</label>
					</div>
				</div>
				<h3 id ="rainfall"><span id="lang_rainfall"><?php echo $TT_Rainfall; ?></span>:</h3>
				<div class="tbl_row">
					<div class="tbl_cell">
						<input id="rad_unitsRain1" type="radio" name="rad_unitsRain" value="mm" checked onclick="gauges.setUnits(this);"><label id="lab_unitsRain1" for="rad_unitsRain1">mm</label>
					</div>
					<div class="tbl_cell">
						<input id="rad_unitsRain2" type="radio" name="rad_unitsRain" value="in" onclick="gauges.setUnits(this);"><label id="lab_unitsRain2" for="rad_unitsRain2">Inch</label>
					</div>
				</div>
				<h3 id="pressure"><span id="lang_pressure"><?php echo $Tr_press; ?></span>:</h3>
				<div class="tbl_row">
					<div class="tbl_cell">
						<input id="rad_unitsPress1" type="radio" name="rad_unitsPress" value="hPa" checked onclick="gauges.setUnits(this);"><label id="lab_unitsPress1" for="rad_unitsPress1">hPa</label>
					</div>
					<div class="tbl_cell">
						<input id="rad_unitsPress2" type="radio" name="rad_unitsPress" value="inHg" onclick="gauges.setUnits(this);"><label id="lab_unitsPress2" for="rad_unitsPress2">inHg</label>
					</div>
				</div>
				<div class="tbl_row">
					<div class="tbl_cell">
						<input id="rad_unitsPress3" type="radio" name="rad_unitsPress" value="mb" onclick="gauges.setUnits(this);"><label id="lab_unitsPress3" for="rad_unitsPress3">mb</label>
					</div>
					<div class="tbl_cell">
						<input id="rad_unitsPress4" type="radio" name="rad_unitsPress" value="kPa" onclick="gauges.setUnits(this);"><label id="lab_unitsPress4" for="rad_unitsPress4">kPa</label>
					</div>
				</div>
				<h3 id="wind"><span id="lang_windSpeed">Wind Speed</span>:</h3>
				<div class="tbl_row">
					<div class="tbl_cell">
						<input id="rad_unitsWind4" type="radio" name="rad_unitsWind" value="km/h" checked onclick="gauges.setUnits(this);"><label id="lab_unitsWind4" for="rad_unitsWind4">km/h</label>
					</div>
					<div class="tbl_cell">
						<input id="rad_unitsWind3" type="radio" name="rad_unitsWind" value="m/s" onclick="gauges.setUnits(this);"><label id="lab_unitsWind3" for="rad_unitsWind3">m/s</label>
					</div>
				</div>
				<div class="tbl_row">
					<div class="tbl_cell">
						<p><input id="rad_unitsWind1" type="radio" name="rad_unitsWind" value="mph" onclick="gauges.setUnits(this);"><label id="lab_unitsWind1" for="rad_unitsWind1">mph</label></p>
					</div>
					<div class="tbl_cell">
						<input id="rad_unitsWind2" type="radio" name="rad_unitsWind" value="kts" onclick="gauges.setUnits(this);"><label id="lab_unitsWind2" for="rad_unitsWind2">knots</label>
					</div>
				</div>
			</div>
			
			
		</div>
    <div id="sidebar-credit">
			Design <a href="http://wptemplates.org/" title="Wordpress Themes">Wp Templates</a><p> and <a href="http://www.thoughtmechanics.com/chicago-web-design-company/" title="Designed By TM">Designed By TM</a>.</p>
		</div>
	</div>
  <!-- Cente  -->
	<div id="base_header">
		<h1 style="text-align: center"><?php echo $Tr_welcome; ?> Weather Sunset Template<br /><small>from Weather by You!</small></h1>
	</div>
	<div id="wrap">
		<div id="content_top" style="margin-top: 0px;"></div>
		<div id="content" style="height:1300px;">
			<div>
				<div id="upper_panel">
				<div class="content" style="padding-top: 8px; text-align: center;">
					<h1 style="margin-bottom: 13px; color:#6D442E">Real time <span id='lang_weather'>weather</span></h1>
					<noscript>
						<h2 style="color:red; text-align:center">&gt;&gt;This pages requires JavaScript enabling in your browser.&lt;&lt;<br>&gt;&gt;Please enable scripting it to enjoy this site at its best.&lt;&lt;</h2>
					</noscript>
				</div>
				<div class="row">
					<canvas id="canvas_led" width="25" height="25"></canvas>&nbsp;&nbsp;&nbsp;
					<canvas id="canvas_status" width="350" height="25"></canvas>&nbsp;&nbsp;
					<canvas id="canvas_timer" width="50" height="25"></canvas>
				</div>
				</div>
				<div class="row">
					<div id="tip_0" class="gauge">
						<h3><?php echo $now_temp; ?></h3>
						<canvas id="canvas_temp" width="251" height="251"></canvas>
						<br>
					</div>
					<div id="tip_1" class="gauge">
						<h3>Other Temp.</h3>
						<canvas id="canvas_dew" width="251" height="251"></canvas>
					</div>
					<div id="tip_4" class="gauge">
						<h3><?php echo $now_hum; ?></h3>
						<canvas id="canvas_hum" width="251" height="251"></canvas>
					</div>
				</div>
				<div class="row">
					<div id="tip_5" class="gauge">
						<h3 style="margin-top: 17px"><?php echo $Tr_press; ?></h3>
						<canvas id="canvas_baro" width="251" height="251"></canvas>
					</div>
					<div id="tip_6" class="gauge">
						<h3 style="margin-top: 17px"><?php echo $Tr_wind; ?></h3>
						<canvas id="canvas_wind" width="251" height="251"></canvas>
					</div>
					<div id="tip_7" class="gauge">
						<h3 style="margin-top: 17px"><?php echo $Tr_currentwdir; ?></h3>
						<canvas id="canvas_dir" width="251" height="251"></canvas>
					</div>
				</div>
				<div class="row">
					<div id="tip_2" class="gauge">
						<h3 style="margin-top: 17px"><?php echo $TT_Rainfall; ?></h3>
						<canvas id="canvas_rain" width="251" height="251"></canvas>
					</div>
					<div id="tip_3" class="gauge">
						<h3 style="margin-top: 17px">Rain rate</h3>
						<canvas id="canvas_rrate" width="251" height="251"></canvas>
					</div>
					<div id="tip_8" class="gauge">
						<h3 style="margin-top: 17px"><?php echo $Tr_UV; ?></h3>
						<canvas id="canvas_uv" width="251" height="251"></canvas>
					</div>
				</div>
				<div class="row">
					<div class="gauge">
						<h3 style="margin-top: 17px">Copyrights</h3>
						<p>Scripts by Mark Crossley<br>v <span id="scriptVer"></span></p>
						<p>Gauges drawn using<br>Gerrit Grunwald's<br><a href="http://harmoniccode.blogspot.com" target="_blank">SteelSeries</a> <a href="https://github.com/HanSolo/SteelSeries-Canvas">JS library</a></p>
					<!-- Credits -->
					<p class="credits">
						<?php echo $Tr_update_last; ?>:<br><?php echo $update; ?>
						<br>
						<?php echo $Tr_version; ?><br><span id="programName"></span> v<span id="programVersion"></span> (b<span id="programBuild"></span>)
					</p><!-- Credits -->
					</div>
					<div id="tip_9" class="gauge">
						<h3 style="margin-top: 17px"><?php echo $Tr_SolarRad; ?></h3>
						<canvas id="canvas_solar" width="251" height="251"></canvas>
					</div>
					<div class="gauge">
						<h3 style="margin-top: 17px"><?php echo $Tr_design; ?></h3>
						<p><a href="http://weatherbyyou.com/"><img src="style/logo_wby_carre.gif" alt="Weather by You Logo" title="An other fine quality Weather website template from Weather by You!" /></a></p>
					</div>
				</div>
			</div><!-- id content -->	
    </div>
		<div class="clear"></div>
		</div>
	</div>
	<div id="bg_btm">
		<div id="footer">
			<p id="footer_notes">Copyright (c) 2014 <a href="http://weatherbyyou.com">Weather Sunset</a></p>
		</div>
	</div>
  <script src="lib/jquery-1.8.2.min.js"></script>
  <!-- Combined steelseries.js & tween.js -->
  <script src="lib/steelseries/steelseries.min.js"></script>

  <!-- Once you have customised this scripts to your requirements you should minimise
       and concatenate them into a single file in the same order  as below -->
  <script src="lib/steelseries/language.min.js"></script>
  <script src="lib/steelseries/gauges.js"></script>
</body>
</html>