<?php
$tpl_version = "1.2";
if (isset($_GET['ver'])) {
  echo $tpl_version;
  exit;
	// Date: 2014-12-25
}
session_start(); // start PHP session
// Check if a language has been selected
if (isset($_POST['langue'])) {
  $lang = $_POST['langue'];
  $_SESSION['langue'] = $lang; // store session data
}
elseif(isset($_SESSION['langue'])){
  $lang = $_SESSION['langue']; // Default language
}
else {
  $lang = 'en'; // Default language
  $_SESSION['langue'] = $lang;
}
// Include text and data file
require('lang/text_standard_en.php');  // Fall-back language: English
require('lang/text_standard_'.$lang.'.php');
include('wt_data_inc.php');
// Include language files available in lang folder
include('include/local_lang.php');
// Check if a Davis station
if ($DavisTotalPacketsReceived == "0")
	$davis = FALSE;
else
	$davis = TRUE;
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
	<title><?php echo $location.' - '.$TT_system; ?></title>
	<meta name="keywords" content="Current, actually, last minute" />
	<meta name="description" content="Current weather observations" />
	<link type="text/css" rel="stylesheet" href="style.css" />
  <link rel="stylesheet" type="text/css" href="lib/ajaxtabs/ajaxtabs.css" />
  <script type="text/javascript" src="lib/ajaxtabs/ajaxtabs.js"></script>
	<script type="text/javascript">
		var dayname = new Array ('<?php echo $Tr_sun."','".$Tr_mon."','".$Tr_tue."','".$Tr_wed."','".$Tr_thu."','".$Tr_fri."','".$Tr_sat; ?>');
		var monthname = new Array ('<?php echo $Tr_jan."','".$Tr_feb."','".$Tr_mar."','".$Tr_apr."','".$Tr_may."','".$Tr_jun."','".$Tr_jul."','".$Tr_aug."','".$Tr_sep."','".$Tr_oct."','".$Tr_nov."','".$Tr_dec; ?>');	
	</script>
</head>
<body>
<div id="header">
	<div id="title">
		<h1>Weather Sunset</h1>
		<p><span>by Weather by You!</span></p>
	</div>
	<div id="top_menu">
		<ul>
			<!-- Menu item in inverted order, due to float -->
			<li><a href="system.php">System</a></li>
			<li><a href="infos.php">About</a></li>
			<li><a href="images.php">Images</a></li>
			<li><a href="ss_gauges.php">Gauges</a></li>
			<li><a href="index.php">Home</a></li>
		</ul>
	</div>
</div>
<div id="base">
  <!-- Right Column -->
	<div id="sidebar">
		<div class="sidebar2">
			<div id="select_lang">
			<?php
				if (isset($nb_langues)) {
			?>
      <form id="lang_sel" method="post" action="<?php echo $_SERVER['PHP_SELF']; ?>">
        <h2 style="padding: 0px">Language:</h2>
        <p><select name="langue" class="styled" title="Select one" onchange="document.forms[0].submit();return false;">
          <?php
            $inc = 0;
            while($inc < $nb_langues) {
              if($languages[$inc][0] == $lang)
                echo '<option value="'.$languages[$inc][0].'" selected="selected">'.$languages[$inc][1].'</option>'."\n";
              else
                echo '<option value="'.$languages[$inc][0].'">'.$languages[$inc][1].'</option>'."\n";
              $inc = $inc + 1;
            }
          ?>
        </select></p>
      </form>  
			<?php
				}
			?>
			</div>
			<div id="calendar">
				<script type="text/javascript">
					var timestamp = new Date();
					var date_yyyy = timestamp.getFullYear();
					var date_mmm = timestamp.getMonth();
					var date_dd = timestamp.getDate();
					var date_day = timestamp.getDay();
				</script>
				<span class="time_month"><script type="text/javascript">document.write(date_yyyy);</script><br />
				<script type="text/javascript">document.write(monthname[date_mmm]);</script></span>
				<h3 style="margin: 15px 0px 8px 0px"><script type="text/javascript">document.write(date_dd);</script></h3>
				<p style="margin: 0px;padding: 0px"><script type="text/javascript">document.write(dayname[date_day]);</script></p>
				<div class="clear"></div>
			</div>
			<br />
			<h2 class="title" style="text-align: center"><?php echo $Tr_currcond; ?></h2>
			<div id="observ" class="side_flip">
				<table style="color:#C2AE7D" summary="Most recent observations">
				<tr>
					<td style="text-align:right"><?php echo $now_temp; ?>:</td>
					<td style="text-align:left"><strong><?php echo $temp; ?></strong><small><?php echo $tempunit; ?></small></td>
				</tr><tr>
					<td style="text-align:right"><?php echo $now_hum; ?>:</td>
					<td style="text-align:left"><strong><?php echo $hum; ?></strong><small>%</small></td>
				</tr><tr>
					<td style="text-align:right"><?php echo $Tr_wind; ?>:</td>
					<td style="text-align:left"><strong><?php echo $wspeed; ?></strong> <small><?php echo $windunit; ?></small></td>
				</tr><tr>
					<td style="text-align:right"><?php echo $Tr_windd; ?>:</td>
					<td style="text-align:left"><strong><?php echo $currentwdir; ?></strong></td></tr>
				</table>
				<p style="text-align: center"><em>Last read at <?php echo $timehhmmss; ?></em></p>
			</div>
			<div class="side_flip">
				<h2 style="padding: 10px 0px 0px 0px">Forecast image</h2>
				<p style="margin: 5px"><em>(for&nbsp;next&nbsp;12&nbsp;hours)</em></p>
				<p><img src="style/forecast/forecast_<?php echo $IsFreezing.'_'.$isdaylight.'_'.$forecastnumber; ?>.png" alt="<?php echo $Tr_forecast.': '.$forecast; ?>" title="<?php echo $Tr_forecast.': '.$forecast; ?>" /></p>
				<br />
			</div>
			<div id="moon_box">
				<h2><?php echo $Tr_moonphase; ?></h2>
				<p><img src="images/moon.bmp" alt="Moon icon" title="Moon icon" /></p>
				<p>Phase : <strong><?php echo $moonphase; ?></strong><br /><?php echo $Tr_MoonPercent; ?> <strong><?php echo $MoonPercentAbs; ?>%</strong></p>
			</div>
		</div>
    <div id="sidebar-credit">
			Design <a href="http://wptemplates.org/" title="Wordpress Themes">Wp Templates</a><p> and <a href="http://www.thoughtmechanics.com/chicago-web-design-company/" title="Designed By TM">Designed By TM</a>.</p>
		</div>
	</div>
  <!-- Centre  -->
	<div id="base_header">
		<h1 style="text-align: center"><?php echo $Tr_welcome.' '.$TT_system; ?></h1>
	</div>
	<div id="wrap">
		<div id="content_top" style="margin-top: 0px"></div>
		<div id="content">
			<?php include('system_txt.php'); ?>
    </div>
		<div class="clear"></div>
	</div>
</div>
<div id="bg_btm">
	<div id="footer">
		<p id="footer_notes">Copyright (c) 2014 <a href="http://weatherbyyou.com">Weather by You!</a></p>
	</div>
</div>
</body>
</html>