<?php
$tpl_version = "1.2";
if (isset($_GET['ver'])) {
  echo $tpl_version;
  exit;
	// Date: 2014-12-25
}
session_start(); // start PHP session
// Check if a language has been selected
if (isset($_POST['langue'])) {
  $lang = $_POST['langue'];
  $_SESSION['langue'] = $lang; // store session data
}
elseif(isset($_SESSION['langue'])){
  $lang = $_SESSION['langue']; // Default language
}
else {
  $lang = 'en'; // Default language
  $_SESSION['langue'] = $lang;
}

// Include text and data file
require('lang/text_standard_en.php');  // Fall-back language: English
require('lang/text_standard_'.$lang.'.php');
include('wt_data_inc.php');

// If you have an RG-11 rain sensor, put TRUE
$sensor_rg = FALSE;
// If you have Davis Solar/UV
if ((intval($ET)== 0) AND ($solarTH=="0") AND ($solarYH=="0") AND ($RecentSolarRad=="0"))
	$sensor_solar = FALSE;
else 
	$sensor_solar = TRUE;

echo "<h1>$TT_yesterday</h1>";
echo "<table summary=\"Rollover time\">\n<tr>\n".'<td  style="font-size: 100%">'.$Tr_rollovertime_since."\n</td>\n<td><strong>$rollovertime</strong></td><td>"; 
echo $Tr_localtime."</td></tr>\n</table>\n"; 
?>
<!-- WEATHER DATA BEGIN -->
<table id="tbl_3cols" border="0" cellpadding="0" cellspacing="0" summary="Observations for today">
<col width="350px" />
<col width="200px" />
<col width="125px" />
<tr>
	<td colspan="3" class="tableseparator"><?php echo $TT_TempAndHum; ?></td>
</tr><tr class="td_data">
	<?php echo '<td>'.$Tr_tempYH.'</td><td>'.$tempYH.' '.$tempunit.'</td><td>'.$TtempYHF.'</td>'; ?>
</tr><tr class="td_data">
	<?php echo '<td>'.$Tr_tempYL.'</td><td>'.$tempYL.' '.$tempunit.'</td><td>'.$TtempYLF.'</td>'; ?>
</tr><tr class="td_data">
	<?php echo '<td>'.$Tr_avgtemp.'</td><td>'.$avgtempY.$tempunit."</td><td>&nbsp;</td>\n"; ?>
</tr><tr class="td_data">
	<?php echo '<td>'.$Tr_temprangeY.'</td><td>'.$temprangeY.$tempunit.'</td><td>&nbsp;</td>'; ?>
</tr><tr class="td_data">
	<?php echo '<td>'.$Tr_apptempYH.'</td><td>'.$apptempYH.' '.$tempunit.'</td><td>'.$TapptempYHF.'</td>'; ?>
</tr><tr class="td_data">
	<?php echo '<td>'.$Tr_apptempYL.'</td><td>'.$apptempYL.' '.$tempunit.'</td><td>'.$TapptempYLF.'</td>'; ?>
</tr><tr class="td_data">
	<?php echo '<td>'.$Tr_heatindexYH.'</td><td>'.$heatindexYH.' '.$tempunit.'</td><td>'.$TheatindexYHF.'</td>'; ?>
</tr><tr class="td_data">
	<?php echo '<td>'.$Tr_wchillYL.'</td><td>'.$wchillYL.' '.$tempunit.'</td><td>'.$TwchillYLF.'</td>'; ?>
</tr><tr class="td_data">
	<?php echo '<td>'.$Tr_dewpointYH.'</td><td>'.$dewpointYH.' '.$tempunit.'</td><td>'.$TdewpointYHF.'</td>'; ?>
</tr><tr class="td_data">
	<?php echo '<td>'.$Tr_dewpointYL.'</td><td>'.$dewpointYL.' '.$tempunit.'</td><td>'.$TdewpointYLF.'</td>'; ?>
</tr><tr class="td_data">
	<?php echo '<td>'.$Tr_humYH.'</td><td>'.$humYH.'%</td><td>'.$ThumYHF.'</td>'; ?>
</tr><tr class="td_data">
	<?php echo '<td>'.$Tr_humYL.'</td><td>'.$humYL.'%</td><td>'.$ThumYLF.'</td>'; ?>
</tr><tr class="td_data">
	<?php echo '<td>'.$Tr_heatdegdaysY.'</td><td>'.$heatdegdaysY.'</td><td>&nbsp;</td>'; ?>
</tr><tr class="td_data">
	<?php echo '<td>'.$Tr_cooldegdaysY.'</td><td>'.$cooldegdaysY.'</td><td>&nbsp;</td>'; ?>
</tr>
	<?php 
		if ($sensor_solar) {
			echo '<tr class="td_data"><td>'.$Tr_YSunshineHours.'</td><td>'.$YSunshineHours."</td><td>&nbsp;</td></tr>\n";
			echo '<tr class="td_data"><td>'.$Tr_SolarRad.'</td><td>'.$solarYH.'</td><td>'.$TsolarYHF.'</td></tr>';
			echo '<tr class="td_data"><td>'.$Tr_UV.'</td><td>'.$UVYH.'</td><td>'.$TUVYHF.'</td></tr>';
		}
	?>
<tr>
	<td colspan="3" class="tableseparator"><?php echo $TT_Rainfall; ?></td>
</tr><tr class="td_data">
	<?php echo '<td>'.$Tr_rfallY.'</td><td>'.$rfallY.' '.$rainunit.'</td><td>&nbsp;</td>'; ?>
</tr><tr class="td_data">
	<?php echo '<td>'.$Tr_rrateYM.'</td><td>'.$rrateYM.' '.$rainunit.'/hr</td><td>'.$TrrateYMF.'</td>'; ?>
</tr><tr class="td_data">
	<?php echo '<td>'.$Tr_hourlyrainYH.'</td><td>'.$hourlyrainYH.' '.$rainunit.'</td><td>'.$ThourlyrainYHF.'</td>'; ?>
</tr>
	<?php 
		if ($sensor_rg) 
			echo '<tr class="td_data"><td>RG-11 '.$Tr_rmonth.'</td><td>'.$RG11RainYest.$rainunit.'</td><td>&nbsp;</td></tr><tr>'; 
	?>
<tr>
	<td colspan="3" class="tableseparator"><?php echo $TT_Wind; ?></td>
</tr><tr class="td_data">
	<?php echo '<td>'.$Tr_wgustYM.'</td><td>'.$wgustYM.' '.$windunit.'</td><td>'.$TwgustYMF.'</td>'; ?>
</tr><tr class="td_data">
	<?php echo '<td>'.$Tr_windYM.'</td><td>'.$windYM.' '.$windunit.'</td><td>'.$TwindYMF.'</td>'; ?>
</tr><tr class="td_data">
	<?php echo '<td>'.$Tr_bearingYM.'</td><td>'.$bearingYM.'&deg;</td><td>'.$TwgustYMF.'</td>'; ?>
</tr><tr class="td_data">
	<?php echo '<td>'.$Tr_domwindbearingY.'</td><td>'.$domwindbearingY.'&deg; '.$domwinddirY.'</td><td>&nbsp;</td>'; ?>
</tr><tr class="td_data">
	<?php echo '<td>'.$Tr_windrunY.'</td><td>'.$windrunY.' '.$windrununit.'</td><td>&nbsp;</td>'; ?>
</tr><tr class="td_data">
	<?php echo '<td>'.$Tr_beaufort.'</td><td>'.$Ybeaufort.'</td><td>'.$Ybeaudesc.'</td>'; ?>
</tr><tr>
	<td colspan="3" class="tableseparator"><?php echo $TT_Press; ?></td>
</tr><tr class="td_data">
	<?php echo '<td>'.$Tr_pressYH.'</td><td>'.$pressYH.' '.$pressunit.'</td><td>'.$TpressYHF.'</td>'; ?>
</tr><tr class="td_data">
	<?php echo '<td>'.$Tr_pressYL.'</td><td>'.$pressYL.' '.$pressunit.'</td><td>'.$TpressYLF.'</td>'; ?>
</tr>
</table>
